/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl;

import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import io.getlime.security.powerauth.biometry.IBiometricKeyEncryptor;
import io.getlime.security.powerauth.biometry.IBiometricKeystore;
import io.getlime.security.powerauth.biometry.impl.BiometricKeyEncryptorAes;
import io.getlime.security.powerauth.biometry.impl.BiometricKeyEncryptorRsa;
import io.getlime.security.powerauth.system.PA2Log;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.SecretKey;

@RequiresApi(api=23)
public class BiometricKeystore
implements IBiometricKeystore {
    private static final String KEY_NAME = "io.getlime.PowerAuthKeychain.KeyStore.BiometryKeychain";
    private static final String PROVIDER_NAME = "AndroidKeyStore";
    private KeyStore mKeyStore;

    public BiometricKeystore() {
        try {
            this.mKeyStore = KeyStore.getInstance(PROVIDER_NAME);
            this.mKeyStore.load(null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            PA2Log.e("BiometricKeystore constructor failed: " + e.getMessage(), new Object[0]);
            this.mKeyStore = null;
        }
    }

    @Override
    public boolean isKeystoreReady() {
        return this.mKeyStore != null;
    }

    @Override
    public boolean containsBiometricKeyEncryptor() {
        if (!this.isKeystoreReady()) {
            return false;
        }
        try {
            return this.mKeyStore.containsAlias(KEY_NAME);
        }
        catch (KeyStoreException e) {
            PA2Log.e("BiometricKeystore.containsBiometricKeyEncryptor failed: " + e.getMessage(), new Object[0]);
            return false;
        }
    }

    @Override
    @Nullable
    public IBiometricKeyEncryptor createBiometricKeyEncryptor(boolean invalidateByBiometricEnrollment, boolean useSymmetricKey) {
        this.removeBiometricKeyEncryptor();
        if (useSymmetricKey) {
            return BiometricKeyEncryptorAes.createAesEncryptor(PROVIDER_NAME, KEY_NAME, invalidateByBiometricEnrollment);
        }
        return BiometricKeyEncryptorRsa.createRsaEncryptor(PROVIDER_NAME, KEY_NAME, invalidateByBiometricEnrollment);
    }

    @Override
    public void removeBiometricKeyEncryptor() {
        try {
            if (this.containsBiometricKeyEncryptor()) {
                this.mKeyStore.deleteEntry(KEY_NAME);
            }
        }
        catch (KeyStoreException e) {
            PA2Log.e("BiometricKeystore.removeBiometricKeyEncryptor failed: " + e.getMessage(), new Object[0]);
        }
    }

    @Override
    @Nullable
    public IBiometricKeyEncryptor getBiometricKeyEncryptor() {
        if (!this.isKeystoreReady()) {
            return null;
        }
        try {
            this.mKeyStore.load(null);
            Key key = this.mKeyStore.getKey(KEY_NAME, null);
            if (key instanceof SecretKey) {
                return new BiometricKeyEncryptorAes((SecretKey)key);
            }
            if (key instanceof PrivateKey) {
                return new BiometricKeyEncryptorRsa((PrivateKey)key);
            }
            if (key != null) {
                PA2Log.e("BiometricKeystore.getBiometricKeyEncryptor unknown key type: " + key.toString(), new Object[0]);
            }
            return null;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            PA2Log.e("BiometricKeystore.getBiometricKeyEncryptor failed: " + e.getMessage(), new Object[0]);
            return null;
        }
    }
}

