/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import io.getlime.security.powerauth.biometry.IBiometricKeyEncryptor;
import java.util.Arrays;

public class BiometricAuthenticationRequest {
    @NonNull
    private final CharSequence title;
    @Nullable
    private final CharSequence subtitle;
    @NonNull
    private final CharSequence description;
    private final boolean forceGenerateNewKey;
    private final boolean invalidateByBiometricEnrollment;
    private final boolean userConfirmationRequired;
    private final boolean useSymmetricCipher;
    @NonNull
    private final byte[] rawKeyData;
    @NonNull
    private final IBiometricKeyEncryptor biometricKeyEncryptor;

    private BiometricAuthenticationRequest(@NonNull CharSequence title, @Nullable CharSequence subtitle, @NonNull CharSequence description, boolean forceGenerateNewKey, boolean invalidateByBiometricEnrollment, boolean userConfirmationRequired, boolean useSymmetricCipher, @NonNull byte[] rawKeyData, @NonNull IBiometricKeyEncryptor biometricKeyEncryptor) {
        this.title = title;
        this.subtitle = subtitle;
        this.description = description;
        this.forceGenerateNewKey = forceGenerateNewKey;
        this.invalidateByBiometricEnrollment = invalidateByBiometricEnrollment;
        this.userConfirmationRequired = userConfirmationRequired;
        this.useSymmetricCipher = useSymmetricCipher;
        this.rawKeyData = Arrays.copyOf(rawKeyData, rawKeyData.length);
        this.biometricKeyEncryptor = biometricKeyEncryptor;
    }

    @NonNull
    public CharSequence getTitle() {
        return this.title;
    }

    @Nullable
    public CharSequence getSubtitle() {
        return this.subtitle;
    }

    @NonNull
    public CharSequence getDescription() {
        return this.description;
    }

    public boolean isForceGenerateNewKey() {
        return this.forceGenerateNewKey;
    }

    public boolean isInvalidateByBiometricEnrollment() {
        return this.invalidateByBiometricEnrollment;
    }

    public boolean isUserConfirmationRequired() {
        return this.userConfirmationRequired;
    }

    public boolean isUseSymmetricCipher() {
        return this.useSymmetricCipher;
    }

    @NonNull
    public byte[] getRawKeyData() {
        return this.rawKeyData;
    }

    @NonNull
    public IBiometricKeyEncryptor getBiometricKeyEncryptor() {
        return this.biometricKeyEncryptor;
    }

    public static class Builder {
        @NonNull
        private final Context context;
        private CharSequence title;
        private CharSequence subtitle;
        private CharSequence description;
        private boolean forceGenerateNewKey = false;
        private boolean invalidateByBiometricEnrollment = true;
        private boolean userConfirmationRequired = false;
        private boolean useSymmetricCipher = true;
        private byte[] rawKeyData;
        private IBiometricKeyEncryptor biometricKeyEncryptor;

        public Builder(@NonNull Context context) {
            this.context = context;
        }

        public BiometricAuthenticationRequest build() {
            if (TextUtils.isEmpty((CharSequence)this.title) || TextUtils.isEmpty((CharSequence)this.description)) {
                throw new IllegalArgumentException("Title and description is required.");
            }
            if (this.rawKeyData == null) {
                throw new IllegalArgumentException("RawKeyData is required.");
            }
            if (this.rawKeyData.length < 16) {
                throw new IllegalArgumentException("RawKeyData length is insufficient.");
            }
            if (this.biometricKeyEncryptor == null) {
                throw new IllegalArgumentException("BiometricKeyEncryptor is required.");
            }
            return new BiometricAuthenticationRequest(this.title, this.subtitle, this.description, this.forceGenerateNewKey, this.invalidateByBiometricEnrollment, this.userConfirmationRequired, this.useSymmetricCipher, this.rawKeyData, this.biometricKeyEncryptor);
        }

        public Builder setTitle(@NonNull CharSequence title) {
            this.title = title;
            return this;
        }

        public Builder setTitle(@StringRes int titleId) {
            return this.setTitle(this.context.getText(titleId));
        }

        public Builder setSubtitle(@NonNull CharSequence subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder setSubtitle(@StringRes int subtitleId) {
            return this.setSubtitle(this.context.getText(subtitleId));
        }

        public Builder setDescription(@NonNull CharSequence description) {
            this.description = description;
            return this;
        }

        public Builder setDescription(@StringRes int descriptionId) {
            return this.setDescription(this.context.getText(descriptionId));
        }

        public Builder setForceGenerateNewKey(boolean forceGenerateNewKey, boolean invalidateByBiometricEnrollment, boolean useSymmetricCipher) {
            this.forceGenerateNewKey = forceGenerateNewKey;
            this.invalidateByBiometricEnrollment = invalidateByBiometricEnrollment;
            this.useSymmetricCipher = useSymmetricCipher;
            return this;
        }

        public Builder setUserConfirmationRequired(boolean userConfirmationRequired) {
            this.userConfirmationRequired = userConfirmationRequired;
            return this;
        }

        public Builder setRawKeyData(@NonNull byte[] keyData, @NonNull IBiometricKeyEncryptor biometricKeyEncryptor) {
            this.rawKeyData = keyData;
            this.biometricKeyEncryptor = biometricKeyEncryptor;
            return this;
        }
    }
}

