/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl;

import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import io.getlime.security.powerauth.biometry.BiometricKeyData;
import io.getlime.security.powerauth.biometry.IBiometricKeyEncryptor;
import io.getlime.security.powerauth.system.PA2Log;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

@RequiresApi(api=23)
public class BiometricKeyEncryptorAes
implements IBiometricKeyEncryptor {
    @NonNull
    private final SecretKey key;
    @Nullable
    private Cipher cipher;
    private boolean cipherIsInitialized;
    private boolean encryptorIsUsed;
    private boolean encryptMode;
    private static final String AES_CIPHER = "AES/CBC/PKCS7Padding";

    public BiometricKeyEncryptorAes(@NonNull SecretKey key) {
        this.key = key;
    }

    @Override
    public boolean isAuthenticationRequiredOnEncryption() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Cipher initializeCipher(boolean encryptMode) {
        try {
            if (this.cipherIsInitialized) {
                throw new IllegalStateException("Cipher is already initialized");
            }
            this.cipher = Cipher.getInstance(AES_CIPHER);
            if (this.cipher != null) {
                byte[] zero_iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                IvParameterSpec algorithmSpec = new IvParameterSpec(zero_iv);
                this.cipher.init(1, (Key)this.key, algorithmSpec);
                this.encryptMode = encryptMode;
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            PA2Log.e("BiometricKeyEncryptorAes.initializeCipher failed: " + e.getMessage(), new Object[0]);
            this.cipher = null;
        }
        finally {
            this.cipherIsInitialized = true;
        }
        return this.cipher;
    }

    @Override
    @Nullable
    public BiometricKeyData encryptBiometricKey(@NonNull byte[] key) {
        byte[] derivedKey = this.aesKdf(key, true);
        return derivedKey != null ? new BiometricKeyData(key, derivedKey, true) : null;
    }

    @Override
    @Nullable
    public BiometricKeyData decryptBiometricKey(@NonNull byte[] encryptedKey) {
        byte[] derivedKey = this.aesKdf(encryptedKey, false);
        return derivedKey != null ? new BiometricKeyData(encryptedKey, derivedKey, false) : null;
    }

    @Nullable
    private byte[] aesKdf(@NonNull byte[] keyToDerive, boolean encryptMode) {
        try {
            if (this.cipher == null) {
                throw new IllegalStateException("Cipher is not initialized");
            }
            if (this.encryptMode != encryptMode) {
                throw new IllegalStateException("Encryptor is not configured for " + (encryptMode ? "encryption" : "decryption"));
            }
            if (this.encryptorIsUsed) {
                throw new IllegalStateException("Encryptor cannot be used for the second time");
            }
            this.encryptorIsUsed = true;
            return this.cipher.doFinal(keyToDerive);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            PA2Log.e("BiometricKeyEncryptorAes.aesKdf failed: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    @Nullable
    public static IBiometricKeyEncryptor createAesEncryptor(@NonNull String providerName, @NonNull String keyName, boolean invalidateByBiometricEnrollment) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", providerName);
            KeyGenParameterSpec.Builder keySpecBuilder = new KeyGenParameterSpec.Builder(keyName, 3).setBlockModes(new String[]{"CBC"}).setUserAuthenticationRequired(true).setRandomizedEncryptionRequired(false).setEncryptionPaddings(new String[]{"PKCS7Padding"});
            if (Build.VERSION.SDK_INT >= 24) {
                keySpecBuilder.setInvalidatedByBiometricEnrollment(invalidateByBiometricEnrollment);
            }
            keyGenerator.init((AlgorithmParameterSpec)keySpecBuilder.build());
            SecretKey key = keyGenerator.generateKey();
            return new BiometricKeyEncryptorAes(key);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException | ProviderException e) {
            PA2Log.e("BiometricKeyEncryptorAes.createAesEncryptor failed: " + e.getMessage(), new Object[0]);
            return null;
        }
    }
}

