/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk;

import android.support.annotation.NonNull;

public class PowerAuthKeychainConfiguration {
    public static final String KEYCHAIN_ID_STATUS = "io.getlime.PowerAuthKeychain.StatusKeychain";
    public static final String KEYCHAIN_ID_BIOMETRY = "io.getlime.PowerAuthKeychain.BiometryKeychain";
    public static final String KEYCHAIN_ID_TOKEN_STORE = "io.getlime.PowerAuthKeychain.TokenStoreKeychain";
    public static final String KEYCHAIN_KEY_BIOMETRY_DEFAULT = "io.getlime.PowerAuthKeychain.BiometryKeychain.DefaultKey";
    public static final boolean DEFAULT_LINK_BIOMETRY_ITEMS_TO_CURRENT_SET = true;
    public static final boolean DEFAULT_CONFIRM_BIOMETRIC_AUTHENTICATION = false;
    public static final boolean DEFAULT_AUTHENTICATE_ON_BIOMETRIC_KEY_SETUP = true;
    public static final int DEFAULT_REQUIRED_KEYCHAIN_PROTECTION = 1;
    @NonNull
    private final String keychainIdStatus;
    @NonNull
    private final String keychainIdBiometry;
    @NonNull
    private final String keychainIdTokenStore;
    @NonNull
    private final String keychainKeyBiometryDefault;
    private final boolean linkBiometricItemsToCurrentSet;
    private final boolean confirmBiometricAuthentication;
    private final boolean authenticateOnBiometricKeySetup;
    private final int minimalRequiredKeychainProtection;

    @NonNull
    public String getKeychainStatusId() {
        return this.keychainIdStatus;
    }

    @NonNull
    public String getKeychainBiometryId() {
        return this.keychainIdBiometry;
    }

    @NonNull
    public String getKeychainBiometryDefaultKey() {
        return this.keychainKeyBiometryDefault;
    }

    @NonNull
    public String getKeychainTokenStoreId() {
        return this.keychainIdTokenStore;
    }

    public boolean isLinkBiometricItemsToCurrentSet() {
        return this.linkBiometricItemsToCurrentSet;
    }

    public boolean isConfirmBiometricAuthentication() {
        return this.confirmBiometricAuthentication;
    }

    public boolean isAuthenticateOnBiometricKeySetup() {
        return this.authenticateOnBiometricKeySetup;
    }

    public int getMinimalRequiredKeychainProtection() {
        return this.minimalRequiredKeychainProtection;
    }

    private PowerAuthKeychainConfiguration(@NonNull String keychainIdStatus, @NonNull String keychainIdBiometry, @NonNull String keychainKeyBiometryDefault, @NonNull String keychainIdTokenStore, boolean linkBiometricItemsToCurrentSet, boolean confirmBiometricAuthentication, boolean authenticateOnBiometricKeySetup, int minimalRequiredKeychainProtection) {
        this.keychainIdStatus = keychainIdStatus;
        this.keychainIdBiometry = keychainIdBiometry;
        this.keychainKeyBiometryDefault = keychainKeyBiometryDefault;
        this.keychainIdTokenStore = keychainIdTokenStore;
        this.linkBiometricItemsToCurrentSet = linkBiometricItemsToCurrentSet;
        this.confirmBiometricAuthentication = confirmBiometricAuthentication;
        this.authenticateOnBiometricKeySetup = authenticateOnBiometricKeySetup;
        this.minimalRequiredKeychainProtection = minimalRequiredKeychainProtection;
    }

    public static class Builder {
        @NonNull
        private String keychainStatusId = "io.getlime.PowerAuthKeychain.StatusKeychain";
        @NonNull
        private String keychainBiometryId = "io.getlime.PowerAuthKeychain.BiometryKeychain";
        @NonNull
        private String keychainTokenStoreId = "io.getlime.PowerAuthKeychain.TokenStoreKeychain";
        @NonNull
        private String keychainBiometryDefaultKey = "io.getlime.PowerAuthKeychain.BiometryKeychain.DefaultKey";
        private boolean linkBiometricItemsToCurrentSet = true;
        private boolean confirmBiometricAuthentication = false;
        private boolean authenticateOnBiometricKeySetup = true;
        private int minimalRequiredKeychainProtection = 1;

        @NonNull
        public Builder keychainStatusId(@NonNull String keychainStatusId) {
            this.keychainStatusId = keychainStatusId;
            return this;
        }

        @NonNull
        public Builder keychainBiometryId(@NonNull String keychainBiometryId) {
            this.keychainBiometryId = keychainBiometryId;
            return this;
        }

        @NonNull
        public Builder keychainTokenStoreId(@NonNull String keychainTokenStoreId) {
            this.keychainTokenStoreId = keychainTokenStoreId;
            return this;
        }

        @NonNull
        public Builder keychainBiometryDefaultKey(@NonNull String keychainBiometryDefaultKey) {
            this.keychainBiometryDefaultKey = keychainBiometryDefaultKey;
            return this;
        }

        @NonNull
        public Builder linkBiometricItemsToCurrentSet(boolean linkBiometricItemsToCurrentSet) {
            this.linkBiometricItemsToCurrentSet = linkBiometricItemsToCurrentSet;
            return this;
        }

        @NonNull
        public Builder confirmBiometricAuthentication(boolean confirmBiometricAuthentication) {
            this.confirmBiometricAuthentication = confirmBiometricAuthentication;
            return this;
        }

        @NonNull
        public Builder authenticateOnBiometricKeySetup(boolean authenticate) {
            this.authenticateOnBiometricKeySetup = authenticate;
            return this;
        }

        @NonNull
        public Builder minimalRequiredKeychainProtection(int minimalRequiredKeychainProtection) {
            this.minimalRequiredKeychainProtection = minimalRequiredKeychainProtection;
            return this;
        }

        @NonNull
        public PowerAuthKeychainConfiguration build() {
            return new PowerAuthKeychainConfiguration(this.keychainStatusId, this.keychainBiometryId, this.keychainBiometryDefaultKey, this.keychainTokenStoreId, this.linkBiometricItemsToCurrentSet, this.confirmBiometricAuthentication, this.authenticateOnBiometricKeySetup, this.minimalRequiredKeychainProtection);
        }
    }
}

