/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.keychain.impl;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import io.getlime.security.powerauth.keychain.Keychain;
import io.getlime.security.powerauth.keychain.impl.ReservedKeyImpl;
import java.util.Set;

public class LegacyKeychain
implements Keychain {
    private final String identifier;
    private final Context context;

    public LegacyKeychain(@NonNull Context context, @NonNull String identifier) {
        this.context = context;
        this.identifier = identifier;
    }

    @Override
    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isEncrypted() {
        return false;
    }

    @Override
    public boolean isReservedKey(@NonNull String key) {
        return ReservedKeyImpl.isReservedKey(key);
    }

    @Override
    public synchronized boolean contains(@NonNull String key) {
        ReservedKeyImpl.failOnReservedKey(key);
        return this.getSharedPreferences().contains(key);
    }

    @Override
    public synchronized void remove(@NonNull String key) {
        ReservedKeyImpl.failOnReservedKey(key);
        this.getSharedPreferences().edit().remove(key).apply();
    }

    @Override
    public synchronized void removeAll() {
        this.getSharedPreferences().edit().clear().apply();
    }

    @Override
    @Nullable
    public synchronized byte[] getData(@NonNull String key) {
        String serializedData = this.getStringValue(key);
        if (serializedData != null) {
            byte[] data = Base64.decode((String)serializedData, (int)0);
            return (byte[])(data.length > 0 ? data : null);
        }
        return null;
    }

    @Override
    public synchronized void putData(@Nullable byte[] data, @NonNull String key) {
        String serializedData = data != null && data.length > 0 ? Base64.encodeToString((byte[])data, (int)0) : null;
        this.setStringValue(key, serializedData);
    }

    @Override
    @Nullable
    public synchronized String getString(@NonNull String key) {
        return this.getStringValue(key);
    }

    @Override
    @NonNull
    public synchronized String getString(@NonNull String key, @NonNull String defaultValue) {
        String value = this.getStringValue(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public synchronized void putString(@Nullable String string2, @NonNull String key) {
        this.setStringValue(key, string2);
    }

    @Override
    @Nullable
    public Set<String> getStringSet(@NonNull String key) {
        ReservedKeyImpl.failOnReservedKey(key);
        return this.getSharedPreferences().getStringSet(key, null);
    }

    @Override
    public void putStringSet(@Nullable Set<String> stringSet, @NonNull String key) {
        ReservedKeyImpl.failOnReservedKey(key);
        this.getSharedPreferences().edit().putStringSet(key, stringSet).apply();
    }

    @Override
    public synchronized boolean getBoolean(@NonNull String key, boolean defaultValue) {
        ReservedKeyImpl.failOnReservedKey(key);
        return this.getSharedPreferences().getBoolean(key, defaultValue);
    }

    @Override
    public synchronized void putBoolean(boolean value, @NonNull String key) {
        ReservedKeyImpl.failOnReservedKey(key);
        this.getSharedPreferences().edit().putBoolean(key, value).apply();
    }

    @Override
    public synchronized long getLong(@NonNull String key, long defaultValue) {
        ReservedKeyImpl.failOnReservedKey(key);
        return this.getSharedPreferences().getLong(key, defaultValue);
    }

    @Override
    public synchronized void putLong(long value, @NonNull String key) {
        ReservedKeyImpl.failOnReservedKey(key);
        this.getSharedPreferences().edit().putLong(key, value).apply();
    }

    @Override
    public float getFloat(@NonNull String key, float defaultValue) {
        ReservedKeyImpl.failOnReservedKey(key);
        return this.getSharedPreferences().getFloat(key, defaultValue);
    }

    @Override
    public void putFloat(float value, @NonNull String key) {
        ReservedKeyImpl.failOnReservedKey(key);
        this.getSharedPreferences().edit().putFloat(key, value).apply();
    }

    @NonNull
    private SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences(this.identifier, 0);
    }

    @Nullable
    private String getStringValue(@NonNull String key) {
        ReservedKeyImpl.failOnReservedKey(key);
        return this.getSharedPreferences().getString(key, null);
    }

    private void setStringValue(@NonNull String key, @Nullable String value) {
        ReservedKeyImpl.failOnReservedKey(key);
        this.getSharedPreferences().edit().putString(key, value).apply();
    }
}

