/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.keychain.impl;

import android.support.annotation.NonNull;
import io.getlime.security.powerauth.keychain.IllegalKeychainAccessException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class KeychainValueEncoder {
    private static final byte TYPE_DATA = 1;
    private static final byte TYPE_STRING = 2;
    private static final byte TYPE_BOOLEAN = 3;
    private static final byte TYPE_LONG = 4;
    private static final byte TYPE_FLOAT = 5;
    private static final byte TYPE_STRING_SET = 6;

    KeychainValueEncoder() {
    }

    @NonNull
    byte[] encode(@NonNull byte[] value) {
        byte[] encoded = new byte[1 + value.length];
        encoded[0] = 1;
        System.arraycopy(value, 0, encoded, 1, value.length);
        return encoded;
    }

    @NonNull
    byte[] encode(@NonNull String value) {
        byte[] encodedString = value.getBytes(Charset.defaultCharset());
        byte[] encoded = new byte[1 + encodedString.length];
        encoded[0] = 2;
        System.arraycopy(encodedString, 0, encoded, 1, encodedString.length);
        return encoded;
    }

    @NonNull
    byte[] encode(boolean value) {
        byte[] encoded = new byte[]{3, value ? (byte)1 : 0};
        return encoded;
    }

    @NonNull
    byte[] encode(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(9);
        buffer.put((byte)4);
        buffer.putLong(value);
        return buffer.array();
    }

    @NonNull
    byte[] encode(float value) {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.put((byte)5);
        buffer.putFloat(value);
        return buffer.array();
    }

    @NonNull
    byte[] encode(@NonNull Set<String> strings) {
        int count = strings.size();
        ArrayList<byte[]> encodedStrings = new ArrayList<byte[]>(count);
        int stringsLength = 0;
        for (String string2 : strings) {
            byte[] encodedString = string2.getBytes(Charset.defaultCharset());
            encodedStrings.add(encodedString);
            stringsLength += encodedString.length;
        }
        int totalLength = 5 + 4 * count + stringsLength;
        ByteBuffer buffer = ByteBuffer.allocate(totalLength);
        buffer.put((byte)6);
        buffer.putInt(count);
        for (int index = 0; index < count; ++index) {
            byte[] encodedString = (byte[])encodedStrings.get(index);
            int encodedStringLength = encodedString.length;
            buffer.putInt(encodedStringLength);
            buffer.put(encodedString);
        }
        return buffer.array();
    }

    @NonNull
    byte[] decodeBytes(@NonNull byte[] encoded) {
        this.checkEncodedType(encoded, (byte)1);
        return Arrays.copyOfRange(encoded, 1, encoded.length);
    }

    @NonNull
    String decodeString(@NonNull byte[] encoded) {
        this.checkEncodedType(encoded, (byte)2);
        return new String(encoded, 1, encoded.length - 1, Charset.defaultCharset());
    }

    boolean decodeBoolean(@NonNull byte[] encoded) {
        this.checkEncodedType(encoded, (byte)3);
        return encoded[1] != 0;
    }

    long decodeLong(@NonNull byte[] encoded) {
        this.checkEncodedType(encoded, (byte)4);
        return ByteBuffer.wrap(encoded, 1, 8).getLong();
    }

    float decodeFloat(@NonNull byte[] encoded) {
        this.checkEncodedType(encoded, (byte)5);
        return ByteBuffer.wrap(encoded, 1, 4).getFloat();
    }

    @NonNull
    Set<String> decodeStringSet(@NonNull byte[] encoded) {
        this.checkEncodedType(encoded, (byte)6);
        try {
            ByteBuffer buffer = ByteBuffer.wrap(encoded, 1, encoded.length - 1);
            int count = buffer.getInt();
            HashSet<String> stringSet = new HashSet<String>(count);
            for (int index = 0; index < count; ++index) {
                int encodedLength = buffer.getInt();
                byte[] encodedString = new byte[encodedLength];
                buffer.get(encodedString);
                stringSet.add(new String(encodedString, Charset.defaultCharset()));
            }
            return stringSet;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalKeychainAccessException("Not enough bytes for Set<String> value", e);
        }
    }

    private void checkEncodedType(@NonNull byte[] encoded, byte expected) {
        if (encoded.length == 0) {
            throw new IllegalKeychainAccessException("Invalid encoded keychain content");
        }
        if (encoded[0] != expected) {
            throw new IllegalKeychainAccessException("Requesting '" + this.typeToString(expected) + "' but keychain contains '" + this.typeToString(encoded[0]) + "' type");
        }
        switch (expected) {
            case 1: 
            case 2: {
                return;
            }
            case 3: {
                if (encoded.length != 2) {
                    throw new IllegalKeychainAccessException("Not enough bytes for Boolean value");
                }
                return;
            }
            case 4: {
                if (encoded.length != 9) {
                    throw new IllegalKeychainAccessException("Not enough bytes for Long value");
                }
                return;
            }
            case 5: {
                if (encoded.length != 5) {
                    throw new IllegalKeychainAccessException("Not enough bytes for Float value");
                }
                return;
            }
            case 6: {
                if (encoded.length >= 5) break;
                throw new IllegalKeychainAccessException("Not enough bytes for Set<String> value");
            }
        }
    }

    @NonNull
    private String typeToString(byte encodedType) {
        switch (encodedType) {
            case 1: {
                return "byte[]";
            }
            case 2: {
                return "String";
            }
            case 3: {
                return "Boolean";
            }
            case 4: {
                return "Long";
            }
            case 5: {
                return "Float";
            }
            case 6: {
                return "Set<String>";
            }
        }
        return "Unknown";
    }
}

