/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.ecies;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.getlime.security.powerauth.core.EciesEncryptor;
import io.getlime.security.powerauth.core.Session;
import io.getlime.security.powerauth.core.SignatureUnlockKeys;
import io.getlime.security.powerauth.ecies.EciesEncryptorId;
import io.getlime.security.powerauth.ecies.EciesMetadata;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import java.nio.charset.Charset;

public class EciesEncryptorFactory {
    private final Session mSession;
    private final byte[] mPossessionUnlockKey;

    public EciesEncryptorFactory(@NonNull Session session, @Nullable byte[] possessionUnlockKey) {
        this.mSession = session;
        this.mPossessionUnlockKey = possessionUnlockKey;
    }

    @NonNull
    public EciesEncryptor getEncryptor(@NonNull EciesEncryptorId identifier) throws PowerAuthErrorException {
        if (identifier == EciesEncryptorId.NONE) {
            throw new PowerAuthErrorException(15, "'NONE' encryptor cannot be created.");
        }
        return this.getEncryptor(identifier.scope, identifier.sharedInfo1, identifier.hasMetadata);
    }

    @NonNull
    private EciesEncryptor getEncryptor(@NonNull int scope, @Nullable String sharedInfo1, boolean addMetaData) throws PowerAuthErrorException {
        SignatureUnlockKeys unlockKeys;
        String activationId;
        byte[] sharedInfo1Bytes;
        byte[] byArray = sharedInfo1Bytes = sharedInfo1 != null ? sharedInfo1.getBytes(Charset.defaultCharset()) : null;
        if (scope == 1) {
            if (this.mPossessionUnlockKey == null) {
                throw new PowerAuthErrorException(15, "Device related key is missing for activation scoped encryptor.");
            }
            activationId = this.mSession.getActivationIdentifier();
            unlockKeys = new SignatureUnlockKeys(this.mPossessionUnlockKey, null, null);
        } else {
            activationId = null;
            unlockKeys = null;
        }
        EciesEncryptor encryptor = this.mSession.getEciesEncryptor(scope, unlockKeys, sharedInfo1Bytes);
        if (encryptor == null) {
            throw new PowerAuthErrorException(14, "Failed to create ECIES encryptor.");
        }
        if (addMetaData) {
            encryptor.setMetadata(new EciesMetadata(this.mSession.getSessionSetup().applicationKey, activationId));
        }
        return encryptor;
    }
}

