/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl.legacy;

import android.hardware.fingerprint.FingerprintManager;
import android.os.Build;
import android.os.CancellationSignal;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.sdk.impl.DefaultCallbackDispatcher;
import io.getlime.security.powerauth.sdk.impl.ICallbackDispatcher;
import io.getlime.security.powerauth.system.PA2Log;

@RequiresApi(api=23)
class FingerprintAuthenticationHandler
extends FingerprintManager.AuthenticationCallback {
    @NonNull
    private final FingerprintManager fingerprintManager;
    @NonNull
    private final FingerprintManager.CryptoObject cryptoObject;
    @NonNull
    private final CancellationSignal cancellationSignal;
    @NonNull
    private final ResultCallback resultCallback;
    @NonNull
    private final ICallbackDispatcher progressDispatcher;
    @Nullable
    private ProgressListener progressListener;
    private boolean isInProgress;
    private boolean isInExit;
    private boolean resultIsAcquired;
    private boolean resultIsReported;
    private boolean authenticationFailedBefore;
    private FingerprintManager.AuthenticationResult resultSuccess;
    private PowerAuthErrorException resultError;

    FingerprintAuthenticationHandler(@NonNull FingerprintManager fingerprintManager, @NonNull FingerprintManager.CryptoObject cryptoObject, @NonNull CancellationSignal cancellationSignal, @Nullable ProgressListener progressListener, @NonNull ResultCallback resultCallback) {
        this.fingerprintManager = fingerprintManager;
        this.cryptoObject = cryptoObject;
        this.cancellationSignal = cancellationSignal;
        this.progressListener = progressListener;
        this.resultCallback = resultCallback;
        this.progressDispatcher = new DefaultCallbackDispatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startListening() {
        FingerprintAuthenticationHandler fingerprintAuthenticationHandler = this;
        synchronized (fingerprintAuthenticationHandler) {
            if (this.isInProgress || this.isInExit || this.cancellationSignal.isCanceled()) {
                return;
            }
            this.isInProgress = true;
            try {
                this.fingerprintManager.authenticate(this.cryptoObject, this.cancellationSignal, 0, (FingerprintManager.AuthenticationCallback)this, null);
            }
            catch (NullPointerException ex) {
                PA2Log.d("FingerprintManager crashed at exception: " + ex.getMessage(), new Object[0]);
                this.onAuthenticationError(5, "Canceled due to an internal failure.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopListening() {
        FingerprintAuthenticationHandler fingerprintAuthenticationHandler = this;
        synchronized (fingerprintAuthenticationHandler) {
            if (!this.isInProgress) {
                return;
            }
            this.isInProgress = false;
            this.isInExit = true;
            this.cancellationSignal.cancel();
        }
    }

    public void onAuthenticationError(final int errorCode, CharSequence errString) {
        boolean isLockout;
        super.onAuthenticationError(errorCode, errString);
        final String errorString = errString != null ? errString.toString() : this.resultCallback.getFallbackErrorMessage(errorCode);
        boolean isCancel = errorCode == 5;
        boolean bl = isLockout = errorCode == 7;
        if (Build.VERSION.SDK_INT >= 27) {
            isCancel |= errorCode == 10;
            isLockout |= errorCode == 9;
        }
        if (isCancel) {
            this.setCancelResult();
        } else {
            PowerAuthErrorException result = isLockout && this.authenticationFailedBefore ? new PowerAuthErrorException(20, "Biometric image was not recognized.") : new PowerAuthErrorException(19, errorString);
            this.setFailureResult(result);
        }
        final boolean doCancel = isCancel;
        this.progressDispatcher.dispatchCallback(new Runnable(){

            @Override
            public void run() {
                if (FingerprintAuthenticationHandler.this.progressListener != null) {
                    if (doCancel) {
                        FingerprintAuthenticationHandler.this.progressListener.onAuthenticationCancel();
                    } else {
                        FingerprintAuthenticationHandler.this.progressListener.onAuthenticationError(errorCode, errorString);
                    }
                } else {
                    FingerprintAuthenticationHandler.this.reportResult();
                }
            }
        });
    }

    public void onAuthenticationHelp(final int helpCode, final CharSequence helpString) {
        super.onAuthenticationHelp(helpCode, helpString);
        this.progressDispatcher.dispatchCallback(new Runnable(){

            @Override
            public void run() {
                if (FingerprintAuthenticationHandler.this.progressListener != null) {
                    FingerprintAuthenticationHandler.this.progressListener.onAuthenticationHelp(helpCode, helpString);
                }
            }
        });
    }

    public void onAuthenticationSucceeded(FingerprintManager.AuthenticationResult result) {
        super.onAuthenticationSucceeded(result);
        this.setSuccessResult(result);
        this.progressDispatcher.dispatchCallback(new Runnable(){

            @Override
            public void run() {
                if (FingerprintAuthenticationHandler.this.progressListener != null) {
                    FingerprintAuthenticationHandler.this.progressListener.onAuthenticationSuccess();
                } else {
                    FingerprintAuthenticationHandler.this.reportResult();
                }
            }
        });
    }

    public void onAuthenticationFailed() {
        super.onAuthenticationFailed();
        this.progressDispatcher.dispatchCallback(new Runnable(){

            @Override
            public void run() {
                FingerprintAuthenticationHandler.this.authenticationFailedBefore = true;
                if (FingerprintAuthenticationHandler.this.progressListener != null) {
                    FingerprintAuthenticationHandler.this.progressListener.onAuthenticationFailed();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSuccessResult(@NonNull FingerprintManager.AuthenticationResult result) {
        FingerprintAuthenticationHandler fingerprintAuthenticationHandler = this;
        synchronized (fingerprintAuthenticationHandler) {
            if (!this.resultIsAcquired) {
                this.resultIsAcquired = true;
                this.resultSuccess = result;
            }
            this.stopListening();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFailureResult(@NonNull PowerAuthErrorException exception) {
        FingerprintAuthenticationHandler fingerprintAuthenticationHandler = this;
        synchronized (fingerprintAuthenticationHandler) {
            if (!this.resultIsAcquired) {
                this.resultIsAcquired = true;
                this.resultError = exception;
            }
            this.stopListening();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCancelResult() {
        FingerprintAuthenticationHandler fingerprintAuthenticationHandler = this;
        synchronized (fingerprintAuthenticationHandler) {
            this.resultIsAcquired = true;
            this.stopListening();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportResult() {
        FingerprintAuthenticationHandler fingerprintAuthenticationHandler = this;
        synchronized (fingerprintAuthenticationHandler) {
            if (!this.resultIsReported) {
                this.resultIsReported = true;
                if (this.resultSuccess != null) {
                    this.resultCallback.onAuthenticationSuccess(this.resultSuccess);
                } else if (this.resultError != null) {
                    this.resultCallback.onAuthenticationFailure(this.resultError);
                } else {
                    this.resultCallback.onAuthenticationCancel(true);
                }
            }
            this.stopListening();
        }
    }

    void removeProgressListener() {
        this.progressListener = null;
    }

    public static interface ProgressListener {
        public void onAuthenticationError(int var1, CharSequence var2);

        public void onAuthenticationHelp(int var1, CharSequence var2);

        public void onAuthenticationFailed();

        public void onAuthenticationSuccess();

        public void onAuthenticationCancel();
    }

    public static interface ResultCallback {
        public void onAuthenticationSuccess(@NonNull FingerprintManager.AuthenticationResult var1);

        public void onAuthenticationFailure(@NonNull PowerAuthErrorException var1);

        public void onAuthenticationCancel(boolean var1);

        @NonNull
        public String getFallbackErrorMessage(int var1);
    }
}

