/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.core;

import android.util.Pair;
import io.getlime.security.powerauth.core.EciesCryptogram;
import io.getlime.security.powerauth.ecies.EciesMetadata;

public class EciesEncryptor {
    private long handle;
    private EciesMetadata metadata;

    public EciesEncryptor(String publicKey, byte[] sharedInfo1, byte[] sharedInfo2) {
        this.handle = this.init(publicKey, sharedInfo1, sharedInfo2);
    }

    public EciesEncryptor copyForDecryption() {
        long handleCopy = this.copyHandleForDecryption();
        if (handleCopy != 0L) {
            return new EciesEncryptor(handleCopy);
        }
        return null;
    }

    private EciesEncryptor(long handle) {
        this.handle = handle;
    }

    public synchronized void destroy() {
        if (this.handle != 0L) {
            this.destroy(this.handle);
            this.handle = 0L;
        }
    }

    protected void finalize() {
        this.destroy();
    }

    private native void destroy(long var1);

    private native long init(String var1, byte[] var2, byte[] var3);

    private native long copyHandleForDecryption();

    public native String getPublicKey();

    public native byte[] getSharedInfo1();

    public native byte[] getSharedInfo2();

    public native boolean canEncryptRequest();

    public native boolean canDecryptResponse();

    public native EciesCryptogram encryptRequest(byte[] var1);

    public synchronized Pair<EciesEncryptor, EciesCryptogram> encryptRequestSynchronized(byte[] requestData) {
        EciesEncryptor decryptor;
        EciesCryptogram cryptogram = this.encryptRequest(requestData);
        if (cryptogram != null && (decryptor = this.copyForDecryption()) != null) {
            decryptor.setMetadata(this.metadata);
            return new Pair((Object)decryptor, (Object)cryptogram);
        }
        return null;
    }

    public native byte[] decryptResponse(EciesCryptogram var1);

    public void setMetadata(EciesMetadata metadata) {
        this.metadata = metadata;
    }

    public EciesMetadata getMetadata() {
        return this.metadata;
    }

    static {
        System.loadLibrary("PowerAuth2Module");
    }
}

