/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class BiometricHelper {
    @NonNull
    public static PowerAuthErrorException getExceptionForBiometricStatus(int status) {
        switch (status) {
            case 2: {
                return new PowerAuthErrorException(19, "Biometric data is not enrolled on the device.");
            }
            case 1: {
                return new PowerAuthErrorException(18, "Biometry is not supported on the device.");
            }
            case 3: {
                return new PowerAuthErrorException(19, "Biometry is not available. Try again later.");
            }
            case 0: {
                throw new IllegalArgumentException("Cannot get exception for success status.");
            }
        }
        throw new IllegalArgumentException("Unknown status.");
    }

    @RequiresApi(api=23)
    @Nullable
    public static Cipher createAesCipher(@NonNull SecretKey key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            byte[] zero_iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            IvParameterSpec algorithmSpec = new IvParameterSpec(zero_iv);
            cipher.init(1, (Key)key, algorithmSpec);
            return cipher;
        }
        catch (NoSuchPaddingException e) {
            return null;
        }
        catch (InvalidAlgorithmParameterException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (InvalidKeyException e) {
            return null;
        }
    }

    @Nullable
    public static byte[] protectKeyWithCipher(@NonNull byte[] keyToProtect, @NonNull Cipher cipher) {
        try {
            return cipher.doFinal(keyToProtect);
        }
        catch (IllegalBlockSizeException e) {
            return null;
        }
        catch (BadPaddingException e) {
            return null;
        }
    }
}

