/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.DialogFragment;

public class BiometricErrorDialogFragment
extends DialogFragment {
    private static final String ARG_TITLE = "arg_title";
    private static final String ARG_MESSAGE = "arg_message";
    private static final String ARG_CLOSE_BUTTON_TEXT = "arg_close_btn_text";
    private static final String ARG_CLOSE_BUTTON_COLOR = "arg_close_btn_color";
    private static final String ARG_ERROR_ICON = "arg_error_icon";
    public static final String FRAGMENT_DEFAULT_TAG = "BIOMETRIC_ERROR_DEFAULT_TAG";
    private OnCloseListener onCloseListener;

    @NonNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        Bundle arguments = this.getArguments();
        AlertDialog.Builder alertBuilder = new AlertDialog.Builder((Context)this.getActivity());
        alertBuilder.setTitle(arguments.getCharSequence(ARG_TITLE));
        alertBuilder.setMessage(arguments.getCharSequence(ARG_MESSAGE));
        alertBuilder.setIcon(arguments.getInt(ARG_ERROR_ICON));
        alertBuilder.setPositiveButton(arguments.getCharSequence(ARG_CLOSE_BUTTON_TEXT), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int i) {
                BiometricErrorDialogFragment.this.dismiss();
            }
        });
        final int closeButtonColor = arguments.getInt(ARG_CLOSE_BUTTON_COLOR);
        final AlertDialog alertDialog = alertBuilder.create();
        alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                if (BiometricErrorDialogFragment.this.isAdded() && Build.VERSION.SDK_INT >= 23) {
                    int color2 = alertDialog.getContext().getColor(closeButtonColor);
                    alertDialog.getButton(-1).setTextColor(color2);
                }
            }
        });
        alertDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                BiometricErrorDialogFragment.this.reportClose();
            }
        });
        return alertDialog;
    }

    private void setOnCloseListener(@NonNull OnCloseListener listener) {
        this.onCloseListener = listener;
    }

    private void reportClose() {
        if (this.onCloseListener != null) {
            this.onCloseListener.onClose();
            this.onCloseListener = null;
        }
    }

    public static class Builder {
        @NonNull
        private final Context context;
        private CharSequence title;
        private CharSequence message;
        private CharSequence closeButton;
        @ColorRes
        private int closeButtonColor;
        @DrawableRes
        private int errorIcon;
        private OnCloseListener onCloseListener;

        public Builder(@NonNull Context context) {
            this.context = context;
        }

        public Builder setTitle(@NonNull CharSequence title) {
            this.title = title;
            return this;
        }

        public Builder setTitle(@StringRes int titleId) {
            this.title = this.context.getText(titleId);
            return this;
        }

        public Builder setMessage(@NonNull CharSequence message) {
            this.message = message;
            return this;
        }

        public Builder setMessage(@StringRes int messageId) {
            this.message = this.context.getText(messageId);
            return this;
        }

        public Builder setIcon(@DrawableRes int iconId) {
            this.errorIcon = iconId;
            return this;
        }

        public Builder setCloseButton(@NonNull CharSequence closeButton, @ColorRes int colorId) {
            this.closeButton = closeButton;
            this.closeButtonColor = colorId;
            return this;
        }

        public Builder setCloseButton(@StringRes int closeButtonId, @ColorRes int colorId) {
            this.closeButton = this.context.getText(closeButtonId);
            this.closeButtonColor = colorId;
            return this;
        }

        public Builder setOnCloseListener(@NonNull OnCloseListener listener) {
            this.onCloseListener = listener;
            return this;
        }

        public BiometricErrorDialogFragment build() {
            if (this.title == null || this.message == null || this.closeButton == null) {
                throw new IllegalArgumentException("Required string is missing.");
            }
            if (this.errorIcon == 0 || this.closeButtonColor == 0) {
                throw new IllegalArgumentException("Icon or Button color resource is missing.");
            }
            if (this.onCloseListener == null) {
                throw new IllegalArgumentException("OnCloseListener is not set.");
            }
            BiometricErrorDialogFragment fragment = new BiometricErrorDialogFragment();
            Bundle arguments = new Bundle();
            arguments.putCharSequence(BiometricErrorDialogFragment.ARG_TITLE, this.title);
            arguments.putCharSequence(BiometricErrorDialogFragment.ARG_MESSAGE, this.message);
            arguments.putCharSequence(BiometricErrorDialogFragment.ARG_CLOSE_BUTTON_TEXT, this.closeButton);
            arguments.putInt(BiometricErrorDialogFragment.ARG_CLOSE_BUTTON_COLOR, this.closeButtonColor);
            arguments.putInt(BiometricErrorDialogFragment.ARG_ERROR_ICON, this.errorIcon);
            fragment.setArguments(arguments);
            fragment.setOnCloseListener(this.onCloseListener);
            fragment.setRetainInstance(true);
            return fragment;
        }
    }

    public static interface OnCloseListener {
        public void onClose();
    }
}

