/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.keychain.fingerprint;

import android.security.keystore.KeyGenParameterSpec;
import android.support.annotation.RequiresApi;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

@RequiresApi(api=23)
public class FingerprintKeystore {
    private static final String KEY_NAME = "io.getlime.PowerAuthKeychain.KeyStore.BiometryKeychain";
    private static final String PROVIDER_NAME = "AndroidKeyStore";
    private KeyStore mKeyStore;

    public FingerprintKeystore() {
        if (this.mKeyStore == null) {
            try {
                this.mKeyStore = KeyStore.getInstance(PROVIDER_NAME);
                this.mKeyStore.load(null);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                this.mKeyStore = null;
            }
        }
    }

    public boolean isKeystoreReady() {
        return this.mKeyStore != null;
    }

    public boolean containsDefaultKey() {
        try {
            return this.mKeyStore.containsAlias(KEY_NAME);
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    public boolean generateDefaultKey() {
        try {
            this.removeDefaultKey();
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", PROVIDER_NAME);
            KeyGenParameterSpec keySpec = new KeyGenParameterSpec.Builder(KEY_NAME, 3).setBlockModes(new String[]{"CBC"}).setUserAuthenticationRequired(true).setRandomizedEncryptionRequired(false).setEncryptionPaddings(new String[]{"PKCS7Padding"}).build();
            keyGenerator.init((AlgorithmParameterSpec)keySpec);
            keyGenerator.generateKey();
            return true;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException | ProviderException e) {
            return false;
        }
    }

    public boolean removeDefaultKey() {
        try {
            if (this.containsDefaultKey()) {
                this.mKeyStore.deleteEntry(KEY_NAME);
            }
            return true;
        }
        catch (KeyStoreException e) {
            return false;
        }
    }

    public SecretKey getDefaultKey() {
        try {
            this.mKeyStore.load(null);
            return (SecretKey)this.mKeyStore.getKey(KEY_NAME, null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            return null;
        }
    }
}

