/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.util.password;

import io.getlime.security.powerauth.util.password.PasswordStrength;
import io.getlime.security.powerauth.util.password.PasswordType;
import java.util.Arrays;

public class PasswordUtil {
    private static final int PIN_LENGTH_WEAK = 4;
    private static final int PIN_LENGTH_STRONG = 6;

    private static boolean isValid(String password, PasswordType type) {
        return password.matches("^[0-9]{4,}$");
    }

    private static boolean isWeak(String password, PasswordType type) {
        if (password.length() < 4) {
            return true;
        }
        String[] weakList = new String[]{"1234", "1111", "0000", "1212", "7777", "1004", "2000", "4444", "2222", "6969", "9999", "3333", "5555", "6666", "1122", "1313", "8888", "4321", "2001", "1010"};
        return Arrays.asList(weakList).contains(password);
    }

    @Deprecated
    public static PasswordStrength evaluateStrength(String password, PasswordType type) {
        if (!PasswordUtil.isValid(password, type)) {
            return PasswordStrength.INVALID;
        }
        if (PasswordUtil.isWeak(password, type)) {
            return PasswordStrength.WEAK;
        }
        boolean strongPin = password.length() >= 6;
        return strongPin ? PasswordStrength.STRONG : PasswordStrength.NORMAL;
    }
}

