/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.networking.client;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.getlime.security.powerauth.networking.client.HttpClientTask;
import io.getlime.security.powerauth.networking.client.HttpRequestHelper;
import io.getlime.security.powerauth.networking.interfaces.ICancelable;
import io.getlime.security.powerauth.networking.interfaces.IEndpointDefinition;
import io.getlime.security.powerauth.networking.interfaces.IExecutorProvider;
import io.getlime.security.powerauth.networking.interfaces.INetworkResponseListener;
import io.getlime.security.powerauth.sdk.PowerAuthAuthentication;
import io.getlime.security.powerauth.sdk.PowerAuthClientConfiguration;
import io.getlime.security.powerauth.sdk.impl.IPrivateCryptoHelper;
import java.util.concurrent.Executor;

public class HttpClient {
    @NonNull
    private final PowerAuthClientConfiguration configuration;
    @NonNull
    private final String baseUrl;
    @NonNull
    private final IExecutorProvider executorProvider;

    public HttpClient(@NonNull PowerAuthClientConfiguration configuration, @NonNull String baseUrl, @NonNull IExecutorProvider executorProvider) {
        this.configuration = configuration;
        this.baseUrl = baseUrl;
        this.executorProvider = executorProvider;
    }

    @NonNull
    public PowerAuthClientConfiguration getClientConfiguration() {
        return this.configuration;
    }

    @NonNull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @NonNull
    public IExecutorProvider getExecutorProvider() {
        return this.executorProvider;
    }

    @NonNull
    public <TRequest, TResponse> ICancelable post(@Nullable TRequest object, @NonNull IEndpointDefinition<TResponse> endpoint, @NonNull IPrivateCryptoHelper helper, @NonNull INetworkResponseListener<TResponse> listener) {
        return this.post(object, endpoint, helper, null, listener);
    }

    @NonNull
    public <TRequest, TResponse> ICancelable post(@Nullable TRequest object, @NonNull IEndpointDefinition<TResponse> endpoint, @NonNull IPrivateCryptoHelper helper, @Nullable PowerAuthAuthentication authentication, @NonNull INetworkResponseListener<TResponse> listener) {
        HttpRequestHelper<TRequest, TResponse> request = new HttpRequestHelper<TRequest, TResponse>(object, endpoint, authentication);
        HttpClientTask<TRequest, TResponse> task = new HttpClientTask<TRequest, TResponse>(request, this.baseUrl, this.configuration, helper, listener);
        Executor executor = endpoint.isSynchronized() ? this.executorProvider.getSerialExecutor() : this.executorProvider.getConcurrentExecutor();
        task.executeOnExecutor(executor, new Object[]{null, null});
        return task;
    }
}

