/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk;

import io.getlime.security.powerauth.networking.ssl.PA2ClientValidationStrategy;
import io.getlime.security.powerauth.system.PA2Log;

public class PowerAuthClientConfiguration {
    private static final int DEF_CONNECTION_TIMEOUT = 20000;
    private static final int DEF_READ_TIMEOUT = 20000;
    private static final boolean DEF_ALLOW_UNSECURED_CONNECTION = false;
    private int connectionTimeout = 20000;
    private int readTimeout = 20000;
    private boolean allowUnsecuredConnection = false;
    private PA2ClientValidationStrategy clientValidationStrategy;

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isUnsecuredConnectionAllowed() {
        return this.allowUnsecuredConnection;
    }

    public PA2ClientValidationStrategy getClientValidationStrategy() {
        return this.clientValidationStrategy;
    }

    public static class Builder {
        private int connectionTimeout = 20000;
        private int readTimeout = 20000;
        private boolean allowUnsecuredConnection = false;
        private PA2ClientValidationStrategy clientValidationStrategy;

        public Builder timeouts(int connectionTimeout, int readTimeout) {
            this.connectionTimeout = connectionTimeout;
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder allowUnsecuredConnection(boolean allow) {
            this.allowUnsecuredConnection = allow;
            if (allow) {
                PA2Log.e("Unsecured connection is dangerous for production application.", new Object[0]);
            }
            return this;
        }

        public Builder clientValidationStrategy(PA2ClientValidationStrategy clientValidationStrategy) {
            this.clientValidationStrategy = clientValidationStrategy;
            return this;
        }

        public PowerAuthClientConfiguration build() {
            PowerAuthClientConfiguration powerAuthClientConfiguration = new PowerAuthClientConfiguration();
            powerAuthClientConfiguration.connectionTimeout = this.connectionTimeout;
            powerAuthClientConfiguration.readTimeout = this.readTimeout;
            powerAuthClientConfiguration.allowUnsecuredConnection = this.allowUnsecuredConnection;
            powerAuthClientConfiguration.clientValidationStrategy = this.clientValidationStrategy;
            return powerAuthClientConfiguration;
        }
    }
}

