/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.keychain.fingerprint;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import io.getlime.security.powerauth.R;
import io.getlime.security.powerauth.keychain.fingerprint.FingerprintAuthenticationHandler;
import io.getlime.security.powerauth.keychain.fingerprint.FingerprintCallback;
import io.getlime.security.powerauth.keychain.fingerprint.FingerprintStage;
import io.getlime.security.powerauth.keychain.fingerprint.IFingerprintActionHandler;

@RequiresApi(api=23)
public class FingerprintAuthenticationDialogFragment
extends DialogFragment
implements FingerprintCallback {
    private static final String ARG_TITLE = "arg_title";
    private static final String ARG_DESCRIPTION = "arg_description";
    private static final String ARG_BIOMETRIC_KEY = "arg_biometric_key";
    private static final String ARG_FORCE_GENERATE_NEW_KEY = "arg_force_generate_new_key";
    private static final String FINGERPRINT_DEFAULT_TAG = "FINGERPRINT_DEFAULT_TAG";
    static final long WRN_TIMEOUT_MILLIS = 1600L;
    static final long SUCCESS_DELAY_MILLIS = 800L;
    private ImageView mImgIcon;
    private TextView mTxtStatus;
    private TextView mTxtDescription;
    private IFingerprintActionHandler mAuthenticationCallback;
    private FingerprintAuthenticationHandler mFingerprintAuthenticationHandler;
    private FingerprintStage mStage;
    private FragmentManager fragmentManager;
    private boolean mSelfCancelled;
    private final Runnable mResetErrorTextRunnable = new Runnable(){

        @Override
        public void run() {
            if (FingerprintAuthenticationDialogFragment.this.isAdded()) {
                FingerprintAuthenticationDialogFragment.this.mTxtStatus.setText((CharSequence)FingerprintAuthenticationDialogFragment.this.mTxtStatus.getResources().getString(R.string.fingerprint_dialog_touch_sensor));
                FingerprintAuthenticationDialogFragment.this.mImgIcon.setImageResource(R.drawable.ic_fingerprint_default);
                FingerprintAuthenticationDialogFragment.this.mTxtStatus.setTextColor(FingerprintAuthenticationDialogFragment.this.getContext().getColor(R.color.color_fingerprint_text_secondary));
            }
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mFingerprintAuthenticationHandler = new FingerprintAuthenticationHandler.FingerprintHelperBuilder(this.getContext()).forceGenerateNewKey(this.getArguments().getBoolean(ARG_FORCE_GENERATE_NEW_KEY, false)).callback(this).build();
        this.mStage = this.mFingerprintAuthenticationHandler.initCrypto();
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder alertBuilder = new AlertDialog.Builder((Context)this.getActivity());
        if (this.mStage.equals((Object)FingerprintStage.USE_FINGERPRINT)) {
            alertBuilder.setTitle((CharSequence)this.getArguments().getString(ARG_TITLE));
            alertBuilder.setPositiveButton(R.string.close, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int i) {
                    if (FingerprintAuthenticationDialogFragment.this.mAuthenticationCallback != null) {
                        FingerprintAuthenticationDialogFragment.this.mAuthenticationCallback.onFingerprintDialogCancelled();
                    }
                    FingerprintAuthenticationDialogFragment.this.dismiss();
                }
            });
            LayoutInflater layoutInflater = this.getActivity().getLayoutInflater();
            View view = layoutInflater.inflate(R.layout.dialog_fingerprint_login, null);
            this.mImgIcon = (ImageView)view.findViewById(R.id.fingerprint_icon);
            this.mTxtStatus = (TextView)view.findViewById(R.id.fingerprint_status);
            this.mTxtDescription = (TextView)view.findViewById(R.id.fingerprint_description);
            alertBuilder.setView(view);
            this.mTxtDescription.setText((CharSequence)this.getArguments().getString(ARG_DESCRIPTION));
        } else if (this.mStage.equals((Object)FingerprintStage.INFO_ENROLL_NEW_FINGERPRINT)) {
            this.mFingerprintAuthenticationHandler.stopListening();
            this.mFingerprintAuthenticationHandler.removeKey();
            alertBuilder.setTitle(R.string.fingerprint_dialog_title_new_fingerprint);
            alertBuilder.setMessage(R.string.fingerprint_dialog_description_new_fingerprint);
            alertBuilder.setIcon(R.drawable.ic_fingerprint_error);
            alertBuilder.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int i) {
                    if (FingerprintAuthenticationDialogFragment.this.mAuthenticationCallback != null) {
                        FingerprintAuthenticationDialogFragment.this.mAuthenticationCallback.onFingerprintInfoDialogClosed();
                    }
                    FingerprintAuthenticationDialogFragment.this.dismiss();
                }
            });
        } else if (this.mStage.equals((Object)FingerprintStage.INFO_FINGERPRINT_NOT_AVAILABLE)) {
            this.mFingerprintAuthenticationHandler.stopListening();
            this.mFingerprintAuthenticationHandler.removeKey();
            alertBuilder.setTitle(R.string.fingerprint_dialog_title_no_scanner);
            alertBuilder.setMessage(R.string.fingerprint_dialog_description_no_scanner);
            alertBuilder.setIcon(R.drawable.ic_fingerprint_error);
            alertBuilder.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int i) {
                    if (FingerprintAuthenticationDialogFragment.this.mAuthenticationCallback != null) {
                        FingerprintAuthenticationDialogFragment.this.mAuthenticationCallback.onFingerprintInfoDialogClosed();
                    }
                    FingerprintAuthenticationDialogFragment.this.dismiss();
                }
            });
        } else if (this.mStage.equals((Object)FingerprintStage.INFO_FINGERPRINT_INVALIDATED)) {
            this.mFingerprintAuthenticationHandler.stopListening();
            this.mFingerprintAuthenticationHandler.removeKey();
            alertBuilder.setTitle(R.string.fingerprint_dialog_title_invalidated);
            alertBuilder.setMessage(R.string.fingerprint_dialog_description_invalidated);
            alertBuilder.setIcon(R.drawable.ic_fingerprint_error);
            alertBuilder.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int i) {
                    if (FingerprintAuthenticationDialogFragment.this.mAuthenticationCallback != null) {
                        FingerprintAuthenticationDialogFragment.this.mAuthenticationCallback.onFingerprintInfoDialogClosed();
                    }
                    FingerprintAuthenticationDialogFragment.this.dismiss();
                }
            });
        }
        final AlertDialog alertDialog = alertBuilder.create();
        alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialogInterface) {
                int COLOR_BUTTON_POSITIVE = alertDialog.getContext().getColor(R.color.color_fingerprint_close_button);
                alertDialog.getButton(-1).setTextColor(COLOR_BUTTON_POSITIVE);
            }
        });
        return alertDialog;
    }

    public void onResume() {
        super.onResume();
        this.mSelfCancelled = false;
        if (this.mStage.equals((Object)FingerprintStage.USE_FINGERPRINT)) {
            this.mFingerprintAuthenticationHandler.startListening();
        }
    }

    public void onPause() {
        super.onPause();
        this.mSelfCancelled = true;
        this.mFingerprintAuthenticationHandler.stopListening();
        this.dismiss();
    }

    @Override
    public void onAuthenticated() {
        if (this.isAdded()) {
            this.showSuccess();
        }
    }

    @Override
    public void onAuthenticationHelp(CharSequence helpString) {
        if (this.isAdded()) {
            this.showWarning(helpString);
        }
    }

    @Override
    public void onAuthenticationFailed() {
        if (this.isAdded()) {
            this.showWarning(this.getString(R.string.fingerprint_dialog_not_recognized));
        }
    }

    @Override
    public void onAuthenticationError(CharSequence errString) {
        if (this.isAdded() && !this.mSelfCancelled) {
            this.showError(errString);
        }
    }

    public void setAuthenticationCallback(IFingerprintActionHandler authCallback) {
        this.mAuthenticationCallback = authCallback;
    }

    public void setFragmentManager(FragmentManager fragmentManager) {
        this.fragmentManager = fragmentManager;
    }

    public void show() {
        this.show(this.fragmentManager, FINGERPRINT_DEFAULT_TAG);
    }

    protected void showSuccess() {
        this.mTxtStatus.removeCallbacks(this.mResetErrorTextRunnable);
        this.mImgIcon.setImageResource(R.drawable.ic_fingerprint_success);
        this.mTxtStatus.setText((CharSequence)this.getString(R.string.fingerprint_dialog_success));
        this.mTxtStatus.setTextColor(this.getContext().getColor(R.color.color_fingerprint_success_text));
        this.mImgIcon.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (FingerprintAuthenticationDialogFragment.this.mAuthenticationCallback != null) {
                    byte[] biometricKey = FingerprintAuthenticationDialogFragment.this.getArguments().getByteArray(FingerprintAuthenticationDialogFragment.ARG_BIOMETRIC_KEY);
                    if (biometricKey != null) {
                        byte[] encrypted = FingerprintAuthenticationDialogFragment.this.mFingerprintAuthenticationHandler.encryptedKey(biometricKey);
                        if (encrypted != null) {
                            FingerprintAuthenticationDialogFragment.this.mAuthenticationCallback.onFingerprintDialogSuccess(encrypted);
                        } else {
                            FingerprintAuthenticationDialogFragment.this.mAuthenticationCallback.onFingerprintDialogSuccess(null);
                        }
                    } else {
                        FingerprintAuthenticationDialogFragment.this.mAuthenticationCallback.onFingerprintDialogSuccess(null);
                    }
                }
                FingerprintAuthenticationDialogFragment.this.dismiss();
            }
        }, 800L);
    }

    protected void showError(CharSequence error) {
        this.mImgIcon.setImageResource(R.drawable.ic_fingerprint_error);
        this.mTxtStatus.setText(error);
        this.mTxtStatus.setTextColor(this.getContext().getColor(R.color.color_fingerprint_failure_text));
        this.mTxtStatus.removeCallbacks(this.mResetErrorTextRunnable);
    }

    protected void showWarning(CharSequence error) {
        this.mImgIcon.setImageResource(R.drawable.ic_fingerprint_error);
        this.mTxtStatus.setText(error);
        this.mTxtStatus.setTextColor(this.getContext().getColor(R.color.color_fingerprint_failure_text));
        this.mTxtStatus.removeCallbacks(this.mResetErrorTextRunnable);
        this.mTxtStatus.postDelayed(this.mResetErrorTextRunnable, 1600L);
    }

    public static class DialogFragmentBuilder {
        private String title;
        private String description;
        private byte[] biometricKey;
        private boolean forceGenerateNewKey;

        public DialogFragmentBuilder title(String title) {
            this.title = title;
            return this;
        }

        public DialogFragmentBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DialogFragmentBuilder biometricKey(byte[] biometricKey) {
            this.biometricKey = biometricKey;
            return this;
        }

        public DialogFragmentBuilder forceGenerateNewKey(boolean forceGenerateNewKey) {
            this.forceGenerateNewKey = forceGenerateNewKey;
            return this;
        }

        public FingerprintAuthenticationDialogFragment build() {
            FingerprintAuthenticationDialogFragment dialogFragment = new FingerprintAuthenticationDialogFragment();
            Bundle bundle = new Bundle();
            bundle.putString(FingerprintAuthenticationDialogFragment.ARG_TITLE, this.title);
            bundle.putString(FingerprintAuthenticationDialogFragment.ARG_DESCRIPTION, this.description);
            bundle.putByteArray(FingerprintAuthenticationDialogFragment.ARG_BIOMETRIC_KEY, this.biometricKey);
            bundle.putBoolean(FingerprintAuthenticationDialogFragment.ARG_FORCE_GENERATE_NEW_KEY, this.forceGenerateNewKey);
            dialogFragment.setArguments(bundle);
            dialogFragment.setCancelable(false);
            return dialogFragment;
        }
    }
}

