/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.math;

import coursierapi.shaded.scala.math.BigDecimal;
import coursierapi.shaded.scala.math.BigInt$;
import coursierapi.shaded.scala.math.Ordered;
import coursierapi.shaded.scala.math.ScalaNumber;
import coursierapi.shaded.scala.math.ScalaNumericAnyConversions;
import coursierapi.shaded.scala.math.ScalaNumericConversions;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import java.math.BigInteger;

public final class BigInt
extends ScalaNumber
implements Ordered<BigInt>,
ScalaNumericConversions {
    private BigInteger _bigInteger;
    private final long _long;

    @Override
    public boolean $less$eq(Object that) {
        return Ordered.$less$eq$(this, that);
    }

    @Override
    public int compareTo(Object that) {
        return Ordered.compareTo$(this, that);
    }

    @Override
    public byte toByte() {
        return ScalaNumericAnyConversions.toByte$(this);
    }

    @Override
    public short toShort() {
        return ScalaNumericAnyConversions.toShort$(this);
    }

    @Override
    public int toInt() {
        return ScalaNumericAnyConversions.toInt$(this);
    }

    @Override
    public long toLong() {
        return ScalaNumericAnyConversions.toLong$(this);
    }

    @Override
    public float toFloat() {
        return ScalaNumericAnyConversions.toFloat$(this);
    }

    @Override
    public double toDouble() {
        return ScalaNumericAnyConversions.toDouble$(this);
    }

    @Override
    public int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
    }

    @Override
    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, x);
    }

    private BigInteger _bigInteger() {
        return this._bigInteger;
    }

    private void _bigInteger_$eq(BigInteger x$1) {
        this._bigInteger = x$1;
    }

    private long _long() {
        return this._long;
    }

    private boolean longEncoding() {
        return this._long() != Long.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public BigInteger bigInteger() {
        void var2_2;
        BigInteger read = this._bigInteger();
        if (read != null) {
            return read;
        }
        BigInteger write = BigInteger.valueOf(this._long());
        this._bigInteger_$eq(write);
        return var2_2;
    }

    public int hashCode() {
        if (this.isValidLong()) {
            return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
        }
        return Statics.anyHash(this.bigInteger());
    }

    public boolean equals(Object that) {
        boolean bl;
        if (that instanceof BigInt) {
            BigInt bigInt = (BigInt)that;
            bl = this.equals(bigInt);
        } else if (that instanceof BigDecimal) {
            bl = ((BigDecimal)that).equals(this);
        } else if (that instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(that);
            bl = this.isValidDouble() && this.doubleValue() == d;
        } else if (that instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(that);
            bl = this.isValidFloat() && this.floatValue() == f;
        } else {
            bl = this.isValidLong() && ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, that);
        }
        return bl;
    }

    @Override
    public boolean isValidByte() {
        return this._long() >= (long)-128 && this._long() <= (long)127;
    }

    @Override
    public boolean isValidShort() {
        return this._long() >= (long)Short.MIN_VALUE && this._long() <= (long)Short.MAX_VALUE;
    }

    @Override
    public boolean isValidChar() {
        return this._long() >= (long)0 && this._long() <= (long)65535;
    }

    @Override
    public boolean isValidInt() {
        return this._long() >= Integer.MIN_VALUE && this._long() <= Integer.MAX_VALUE;
    }

    public boolean isValidLong() {
        return this.longEncoding() || BoxesRunTime.equalsNumNum(this._bigInteger(), BigInt$.MODULE$.scala$math$BigInt$$longMinValueBigInteger());
    }

    public boolean isValidFloat() {
        block5: {
            block4: {
                int bitLen = this.bitLength();
                if (bitLen <= 24) break block4;
                int lowest = this.lowestSetBit();
                if (!(bitLen <= 128 && lowest >= bitLen - 24 && lowest < 128)) break block5;
            }
            if (!this.bitLengthOverflow()) {
                return true;
            }
        }
        return false;
    }

    public boolean isValidDouble() {
        block5: {
            block4: {
                int bitLen = this.bitLength();
                if (bitLen <= 53) break block4;
                int lowest = this.lowestSetBit();
                if (!(bitLen <= 1024 && lowest >= bitLen - 53 && lowest < 1024)) break block5;
            }
            if (!this.bitLengthOverflow()) {
                return true;
            }
        }
        return false;
    }

    private boolean bitLengthOverflow() {
        BigInteger shifted = this.bigInteger().shiftRight(Integer.MAX_VALUE);
        return shifted.signum() != 0 && !shifted.equals(BigInt$.MODULE$.scala$math$BigInt$$minusOne());
    }

    @Override
    public boolean isWhole() {
        return true;
    }

    @Override
    public BigInteger underlying() {
        return this.bigInteger();
    }

    public boolean equals(BigInt that) {
        if (this.longEncoding()) {
            return that.longEncoding() && this._long() == that._long();
        }
        return !that.longEncoding() && BoxesRunTime.equalsNumNum(this._bigInteger(), that._bigInteger());
    }

    @Override
    public int compare(BigInt that) {
        if (this.longEncoding()) {
            if (that.longEncoding()) {
                return Long.compare(this._long(), that._long());
            }
            return -that._bigInteger().signum();
        }
        if (that.longEncoding()) {
            return this._bigInteger().signum();
        }
        return this._bigInteger().compareTo(that._bigInteger());
    }

    public int lowestSetBit() {
        if (this.longEncoding()) {
            if (this._long() == 0L) {
                return -1;
            }
            return Long.numberOfTrailingZeros(this._long());
        }
        return this.bigInteger().getLowestSetBit();
    }

    public int bitLength() {
        if (this.longEncoding()) {
            if (this._long() < 0L) {
                return 64 - Long.numberOfLeadingZeros(-(this._long() + 1L));
            }
            return 64 - Long.numberOfLeadingZeros(this._long());
        }
        return this._bigInteger().bitLength();
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public int intValue() {
        if (this.longEncoding()) {
            return (int)this._long();
        }
        return this.bigInteger().intValue();
    }

    @Override
    public long longValue() {
        if (this.longEncoding()) {
            return this._long();
        }
        return this._bigInteger().longValue();
    }

    @Override
    public float floatValue() {
        return this.bigInteger().floatValue();
    }

    @Override
    public double doubleValue() {
        if (this.isValidLong() && -0x20000000000000L <= this._long() && this._long() <= 0x20000000000000L) {
            return this._long();
        }
        return this.bigInteger().doubleValue();
    }

    public String toString() {
        if (this.longEncoding()) {
            return Long.toString(this._long());
        }
        return this._bigInteger().toString();
    }

    public BigInt(BigInteger _bigInteger, long _long) {
        this._bigInteger = _bigInteger;
        this._long = _long;
    }

    public BigInt(BigInteger bigInteger) {
        this(bigInteger, bigInteger.bitLength() <= 63 ? bigInteger.longValue() : Long.MIN_VALUE);
    }
}

