/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.action;

import akka.actor.ActorSystem;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Validation;
import io.gatling.core.action.Action;
import io.gatling.core.action.ChainableAction;
import io.gatling.core.action.ExitableAction;
import io.gatling.core.session.Session;
import io.gatling.core.stats.StatsEngine;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0004\b\u0001/!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u00111\u0003!Q1A\u0005\u00025C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t/\u0002\u0011)\u0019!C\u00011\"A\u0011\r\u0001B\u0001B\u0003%\u0011\f\u0003\u0005c\u0001\t\u0015\r\u0011\"\u0001d\u0011!9\u0007A!A!\u0002\u0013!\u0007\"\u00025\u0001\t\u0003I\u0007\"B9\u0001\t\u0003\u0012(!\u0002)bkN,'BA\b\u0011\u0003\u0019\t7\r^5p]*\u0011\u0011CE\u0001\u0005G>\u0014XM\u0003\u0002\u0014)\u00059q-\u0019;mS:<'\"A\u000b\u0002\u0005%|7\u0001A\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 A5\ta\"\u0003\u0002\"\u001d\tqQ\t_5uC\ndW-Q2uS>t\u0017!\u00049bkN,G)\u001e:bi&|g\u000eE\u0002%i]r!!J\u0019\u000f\u0005\u0019zcBA\u0014/\u001d\tASF\u0004\u0002*Y5\t!F\u0003\u0002,-\u00051AH]8pizJ\u0011!F\u0005\u0003'QI!!\u0005\n\n\u0005A\u0002\u0012aB:fgNLwN\\\u0005\u0003eM\nq\u0001]1dW\u0006<WM\u0003\u00021!%\u0011QG\u000e\u0002\u000b\u000bb\u0004(/Z:tS>t'B\u0001\u001a4!\tI\u0002(\u0003\u0002:5\t!Aj\u001c8h\u0003-\t7\r^8s'f\u001cH/Z7\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014!B1di>\u0014(\"\u0001!\u0002\t\u0005\\7.Y\u0005\u0003\u0005v\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u0006Y1\u000f^1ug\u0016sw-\u001b8f+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%\u0011\u0003\u0015\u0019H/\u0019;t\u0013\tQuIA\u0006Ti\u0006$8/\u00128hS:,\u0017\u0001D:uCR\u001cXI\\4j]\u0016\u0004\u0013!B2m_\u000e\\W#\u0001(\u0011\u0005=#V\"\u0001)\u000b\u0005E\u0013\u0016\u0001B;uS2T!a\u0015\n\u0002\u000f\r|W.\\8og&\u0011Q\u000b\u0015\u0002\u0006\u00072|7m[\u0001\u0007G2|7m\u001b\u0011\u0002\t9\fW.Z\u000b\u00023B\u0011!L\u0018\b\u00037r\u0003\"!\u000b\u000e\n\u0005uS\u0012A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!\u0018\u000e\u0002\u000b9\fW.\u001a\u0011\u0002\t9,\u0007\u0010^\u000b\u0002IB\u0011q$Z\u0005\u0003M:\u0011a!Q2uS>t\u0017!\u00028fqR\u0004\u0013A\u0002\u001fj]&$h\bF\u0004kW2lgn\u001c9\u0011\u0005}\u0001\u0001\"\u0002\u0012\f\u0001\u0004\u0019\u0003\"\u0002\u001e\f\u0001\u0004Y\u0004\"B\"\f\u0001\u0004)\u0005\"\u0002'\f\u0001\u0004q\u0005\"B,\f\u0001\u0004I\u0006\"\u00022\f\u0001\u0004!\u0017aB3yK\u000e,H/\u001a\u000b\u0003gZ\u0004\"!\u0007;\n\u0005UT\"\u0001B+oSRDQ\u0001\r\u0007A\u0002]\u0004\"\u0001_=\u000e\u0003MJ!A_\u001a\u0003\u000fM+7o]5p]\u0002")
public class Pause
implements ExitableAction {
    private final Function1<Session, Validation<Object>> pauseDuration;
    private final ActorSystem actorSystem;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private final String name;
    private final Action next;
    private final Logger logger;

    @Override
    public /* synthetic */ void io$gatling$core$action$ExitableAction$$super$$bang(Session session) {
        ChainableAction.$bang$(this, session);
    }

    @Override
    public void $bang(Session session) {
        ExitableAction.$bang$(this, session);
    }

    @Override
    public /* synthetic */ void io$gatling$core$action$ChainableAction$$super$$bang(Session session) {
        Action.$bang$(this, session);
    }

    @Override
    public void recover(Session session, Validation<?> v) {
        ChainableAction.recover$(this, session, v);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public StatsEngine statsEngine() {
        return this.statsEngine;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Action next() {
        return this.next;
    }

    @Override
    public void execute(Session session) {
        this.recover(session, ((Validation)this.pauseDuration.apply((Object)session)).map$mcJ$sp((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)durationInMillis -> this.schedule$1(durationInMillis, session)));
    }

    private final void schedule$1(long durationInMillis, Session session$1) {
        long drift = session$1.drift();
        if (durationInMillis > drift) {
            BoxedUnit boxedUnit;
            long durationMinusDrift = durationInMillis - drift;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Pausing for {}ms (real={}ms)", new Object[]{BoxesRunTime.boxToLong((long)durationInMillis), BoxesRunTime.boxToLong((long)durationMinusDrift)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            long pauseStart = this.clock().nowMillis();
            try {
                this.actorSystem.scheduler().scheduleOnce(new package.DurationLong(package$.MODULE$.DurationLong(durationMinusDrift)).milliseconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    long newDrift = this.clock().nowMillis() - pauseStart - durationMinusDrift;
                    this.next().$bang(session$1.setDrift(newDrift));
                }, (ExecutionContext)this.actorSystem.dispatcher());
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            BoxedUnit boxedUnit;
            long remainingDrift = drift - durationInMillis;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Can't pause (remaining drift={}ms)", new Object[]{BoxesRunTime.boxToLong((long)remainingDrift)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.actorSystem.dispatcher().execute(() -> this.next().$bang(session$1.setDrift(remainingDrift)));
        }
    }

    public Pause(Function1<Session, Validation<Object>> pauseDuration, ActorSystem actorSystem, StatsEngine statsEngine, Clock clock, String name, Action next) {
        this.pauseDuration = pauseDuration;
        this.actorSystem = actorSystem;
        this.statsEngine = statsEngine;
        this.clock = clock;
        this.name = name;
        this.next = next;
        StrictLogging.$init$((StrictLogging)this);
        Action.$init$(this);
        ChainableAction.$init$(this);
        ExitableAction.$init$(this);
    }
}

