/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.runner;

import akka.actor.ActorRef;
import akka.pattern.AskSupport;
import akka.util.Timeout;
import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.Logging;
import io.gatling.core.action.AkkaDefaults;
import io.gatling.core.action.AkkaDefaults$class;
import io.gatling.core.action.package$;
import io.gatling.core.config.GatlingConfiguration$;
import io.gatling.core.result.message.RunMessage;
import io.gatling.core.result.terminator.Terminator$;
import io.gatling.core.result.writer.DataWriter$;
import io.gatling.core.runner.Selection;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.scenario.Simulation;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0001\u0002\u0001\u0017\t1!+\u001e8oKJT!a\u0001\u0003\u0002\rI,hN\\3s\u0015\t)a!\u0001\u0003d_J,'BA\u0004\t\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!C\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001\u0019IA\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u00051\u0011m\u0019;j_:L!a\u0006\u000b\u0003\u0019\u0005[7.\u0019#fM\u0006,H\u000e^:\u0011\u0005e\u0011S\"\u0001\u000e\u000b\u0005ma\u0012!B:mMRR'BA\u000f\u001f\u00031\u00198-\u00197bY><w-\u001b8h\u0015\ty\u0002%\u0001\u0005usB,7/\u00194f\u0015\u0005\t\u0013aA2p[&\u00111E\u0007\u0002\b\u0019><w-\u001b8h\u0011!)\u0003A!A!\u0002\u00131\u0013!C:fY\u0016\u001cG/[8o!\t9\u0003&D\u0001\u0003\u0013\tI#AA\u0005TK2,7\r^5p]\")1\u0006\u0001C\u0001Y\u00051A(\u001b8jiz\"\"!\f\u0018\u0011\u0005\u001d\u0002\u0001\"B\u0013+\u0001\u00041\u0003\"\u0002\u0019\u0001\t\u0003\t\u0014a\u0001:v]V\t!\u0007\u0005\u0003\u000egUb\u0014B\u0001\u001b\u000f\u0005\u0019!V\u000f\u001d7feA\u0011a'\u000f\b\u0003\u001b]J!\u0001\u000f\b\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003q9\u0001\"!\u0010!\u000e\u0003yR!a\u0010\u0003\u0002\u0011M\u001cWM\\1sS>L!!\u0011 \u0003\u0015MKW.\u001e7bi&|g\u000e")
public class Runner
implements AkkaDefaults,
Logging {
    private final Selection selection;
    private final Logger logger;
    private final Timeout defaultTimeOut;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Runner runner = this;
        synchronized (runner) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public Timeout defaultTimeOut() {
        return this.defaultTimeOut;
    }

    @Override
    public void io$gatling$core$action$AkkaDefaults$_setter_$defaultTimeOut_$eq(Timeout x$1) {
        this.defaultTimeOut = x$1;
    }

    public AskSupport.AskableActorRef ask(ActorRef actorRef) {
        return AskSupport.class.ask((AskSupport)this, (ActorRef)actorRef);
    }

    public Future<Object> ask(ActorRef actorRef, Object message, Timeout timeout) {
        return AskSupport.class.ask((AskSupport)this, (ActorRef)actorRef, (Object)message, (Timeout)timeout);
    }

    public Tuple2<String, Simulation> run() {
        try {
            Class<Simulation> simulationClass = this.selection.simulationClass();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Simulation ", " started..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{simulationClass.getName()})));
            RunMessage runMessage = new RunMessage(DateTime.now(), this.selection.simulationId(), this.selection.description());
            Simulation simulation = simulationClass.newInstance();
            Seq<Scenario> scenarios2 = simulation.scenarios();
            Predef$.MODULE$.require(!scenarios2.isEmpty(), (Function0)new Serializable(this, simulationClass){
                public static final long serialVersionUID = 0L;
                private final Class simulationClass$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " returned an empty scenario list. Did you forget to migrate your Simulations?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.simulationClass$1.getName()}));
                }
                {
                    this.simulationClass$1 = simulationClass$1;
                }
            });
            Seq scenarioNames = (Seq)scenarios2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Scenario x$1) {
                    return x$1.name();
                }
            }, Seq$.MODULE$.canBuildFrom());
            Predef$.MODULE$.require(scenarioNames.toSet().size() == scenarioNames.size(), (Function0)new Serializable(this, scenarioNames){
                public static final long serialVersionUID = 0L;
                private final Seq scenarioNames$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scenario names must be unique but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.scenarioNames$1}));
                }
                {
                    this.scenarioNames$1 = scenarioNames$1;
                }
            });
            int totalNumberOfUsers = BoxesRunTime.unboxToInt((Object)((TraversableOnce)scenarios2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Scenario x$2) {
                    return x$2.injectionProfile().users();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total number of users : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)totalNumberOfUsers)})));
            }
            CountDownLatch terminatorLatch = new CountDownLatch(1);
            Future init = Terminator$.MODULE$.askInit(terminatorLatch, totalNumberOfUsers).flatMap((Function1)new Serializable(this, runMessage, scenarios2){
                public static final long serialVersionUID = 0L;
                private final RunMessage runMessage$1;
                private final Seq scenarios$1;

                public final Future<Seq<Object>> apply(Object x$3) {
                    return DataWriter$.MODULE$.askInit(this.runMessage$1, (Seq<Scenario>)this.scenarios$1);
                }
                {
                    this.runMessage$1 = runMessage$1;
                    this.scenarios$1 = scenarios$1;
                }
            }, (ExecutionContext)package$.MODULE$.system().dispatcher());
            Await$.MODULE$.result((Awaitable)init, (Duration)this.defaultTimeOut().duration());
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Launching All Scenarios");
            }
            scenarios2.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int i, Scenario scenario) {
                    scenario.run(i);
                    return i + scenario.injectionProfile().users();
                }
            });
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Finished Launching scenarios executions");
            }
            terminatorLatch.await(GatlingConfiguration$.MODULE$.configuration().core().timeOut().simulation(), TimeUnit.SECONDS);
            Predef$.MODULE$.println((Object)"Simulation finished.");
            return new Tuple2((Object)runMessage.runId(), (Object)simulation);
        }
        finally {
            package$.MODULE$.system().shutdown();
        }
    }

    public Runner(Selection selection) {
        this.selection = selection;
        AskSupport.class.$init$((AskSupport)this);
        AkkaDefaults$class.$init$(this);
        Logging.class.$init$((Logging)this);
    }
}

