/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.report;

import io.gatling.charts.component.Component;
import io.gatling.charts.component.ComponentLibrary;
import io.gatling.charts.component.DetailsStatsTableComponent;
import io.gatling.charts.component.ErrorsTableComponent;
import io.gatling.charts.config.ChartsFiles;
import io.gatling.charts.report.ReportGenerator;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.SchemaContainerComponent;
import io.gatling.charts.report.TemplateWriter;
import io.gatling.charts.stats.CountsVsTimePlot;
import io.gatling.charts.stats.IntVsTimePlot;
import io.gatling.charts.stats.PercentVsTimePlot;
import io.gatling.charts.stats.PieSlice;
import io.gatling.charts.stats.RequestPath$;
import io.gatling.charts.stats.Series;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.template.RequestDetailsPageTemplate;
import io.gatling.charts.util.Color;
import io.gatling.charts.util.Color$Requests$;
import io.gatling.commons.shared.unstable.model.stats.Group;
import io.gatling.commons.shared.unstable.model.stats.RequestStatsPath;
import io.gatling.commons.shared.unstable.model.stats.StatsPath;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.GatlingConfiguration;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00013Qa\u0002\u0005\u0001\u0015AA\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006Ia\u0006\u0005\t5\u0001\u0011\t\u0011)A\u00057!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005)\u0001\t\u0005\t\u0015a\u0003*\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u0015A\u0004\u0001\"\u0001:\u0005u\u0011V-];fgR$U\r^1jYN\u0014V\r]8si\u001e+g.\u001a:bi>\u0014(BA\u0005\u000b\u0003\u0019\u0011X\r]8si*\u00111\u0002D\u0001\u0007G\"\f'\u000f^:\u000b\u00055q\u0011aB4bi2Lgn\u001a\u0006\u0002\u001f\u0005\u0011\u0011n\\\n\u0003\u0001E\u0001\"AE\n\u000e\u0003!I!\u0001\u0006\u0005\u0003\u001fI+\u0007o\u001c:u\u000f\u0016tWM]1u_J\fqC]3q_J$8oR3oKJ\fG/[8o\u0013:\u0004X\u000f^:\u0004\u0001A\u0011!\u0003G\u0005\u00033!\u0011qCU3q_J$8oR3oKJ\fG/[8o\u0013:\u0004X\u000f^:\u0002\u0017\rD\u0017M\u001d;t\r&dWm\u001d\t\u00039}i\u0011!\b\u0006\u0003=)\taaY8oM&<\u0017B\u0001\u0011\u001e\u0005-\u0019\u0005.\u0019:ug\u001aKG.Z:\u0002!\r|W\u000e]8oK:$H*\u001b2sCJL\bCA\u0012'\u001b\u0005!#BA\u0013\u000b\u0003%\u0019w.\u001c9p]\u0016tG/\u0003\u0002(I\t\u00012i\\7q_:,g\u000e\u001e'jEJ\f'/_\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005)rS\"A\u0016\u000b\u0005ya#BA\u0017\r\u0003\u0011\u0019wN]3\n\u0005=Z#\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0005eU2t\u0007\u0006\u00024iA\u0011!\u0003\u0001\u0005\u0006Q\u0015\u0001\u001d!\u000b\u0005\u0006+\u0015\u0001\ra\u0006\u0005\u00065\u0015\u0001\ra\u0007\u0005\u0006C\u0015\u0001\rAI\u0001\tO\u0016tWM]1uKR\t!\b\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDH\u0001\u0003V]&$\b")
public class RequestDetailsReportGenerator
extends ReportGenerator {
    private final ReportsGenerationInputs reportsGenerationInputs;
    private final ChartsFiles chartsFiles;
    private final ComponentLibrary componentLibrary;
    private final GatlingConfiguration configuration;

    @Override
    public void generate() {
        this.reportsGenerationInputs.logFileData().statsPaths().foreach((Function1 & Serializable)x0$1 -> {
            RequestDetailsReportGenerator.$anonfun$generate$10(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final Component responseTimeDistributionChartComponent$1(String requestName$1, Option group$1) {
        Tuple2<Seq<PercentVsTimePlot>, Seq<PercentVsTimePlot>> tuple2 = this.reportsGenerationInputs.logFileData().responseTimeDistribution(100, (Option<String>)new Some((Object)requestName$1), (Option<Group>)group$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq okDistribution = (Seq)tuple2._1();
        Seq koDistribution = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)okDistribution, (Object)koDistribution);
        Seq okDistribution2 = (Seq)tuple22._1();
        Seq koDistribution2 = (Seq)tuple22._2();
        Series<PercentVsTimePlot> okDistributionSeries = new Series<PercentVsTimePlot>(Series$.MODULE$.OK(), (Iterable<PercentVsTimePlot>)okDistribution2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)Nil$.MODULE$));
        Series<PercentVsTimePlot> koDistributionSeries = new Series<PercentVsTimePlot>(Series$.MODULE$.KO(), (Iterable<PercentVsTimePlot>)koDistribution2, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$));
        return this.componentLibrary.getDistributionComponent("Response Time", "Requests", okDistributionSeries, koDistributionSeries);
    }

    private final Component responseTimeChartComponent$1(String requestName$1, Option group$1) {
        return this.percentilesChartComponent$1((Function3 & Serializable)(status, requestName, group) -> $this.reportsGenerationInputs.logFileData().responseTimePercentilesOverTime((Status)status, (Option<String>)requestName, (Option<Group>)group), (Function2 & Serializable)(x$2, x$3) -> this.componentLibrary.getPercentilesOverTimeComponent("Response Time", BoxesRunTime.unboxToLong((Object)x$2), x$3), "Response Time Percentiles over Time", requestName$1, group$1);
    }

    private final Component percentilesChartComponent$1(Function3 dataSource, Function2 componentFactory, String title, String requestName$1, Option group$1) {
        Iterable successData = (Iterable)dataSource.apply((Object)OK$.MODULE$, (Object)new Some((Object)requestName$1), (Object)group$1);
        Series successSeries = new Series(new StringBuilder(3).append(title).append(" (").append(Series$.MODULE$.OK()).append(")").toString(), successData, Color$Requests$.MODULE$.Percentiles());
        return (Component)componentFactory.apply((Object)BoxesRunTime.boxToLong((long)this.reportsGenerationInputs.logFileData().runInfo().injectStart()), successSeries);
    }

    private final Component requestsChartComponent$1(String requestName$1, Option group$1) {
        return this.countsChartComponent$1((Function2 & Serializable)(requestName, group) -> $this.reportsGenerationInputs.logFileData().numberOfRequestsPerSecond((Option<String>)requestName, (Option<Group>)group), (Function3 & Serializable)(runStart, counts, pieSeries) -> this.componentLibrary.getRequestsComponent(BoxesRunTime.unboxToLong((Object)runStart), counts, pieSeries), requestName$1, group$1);
    }

    private final Component responsesChartComponent$1(String requestName$1, Option group$1) {
        return this.countsChartComponent$1((Function2 & Serializable)(requestName, group) -> $this.reportsGenerationInputs.logFileData().numberOfResponsesPerSecond((Option<String>)requestName, (Option<Group>)group), (Function3 & Serializable)(runStart, counts, pieSeries) -> this.componentLibrary.getResponsesComponent(BoxesRunTime.unboxToLong((Object)runStart), counts, pieSeries), requestName$1, group$1);
    }

    private final Component countsChartComponent$1(Function2 dataSource, Function3 componentFactory, String requestName$1, Option group$1) {
        Seq counts = (Seq)((SeqOps)dataSource.apply((Object)new Some((Object)requestName$1), (Object)group$1)).sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.time()), (Ordering)Ordering.Int$.MODULE$);
        Series countsSeries = new Series("", counts, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.All(), (List)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$))));
        PieSlice okPieSlice = new PieSlice(Series$.MODULE$.OK(), this.count((Seq<CountsVsTimePlot>)counts, (Status)OK$.MODULE$));
        PieSlice koPieSlice = new PieSlice(Series$.MODULE$.KO(), this.count((Seq<CountsVsTimePlot>)counts, (Status)KO$.MODULE$));
        Series pieRequestsSeries = new Series(Series$.MODULE$.Distribution(), new .colon.colon((Object)okPieSlice, (List)new .colon.colon((Object)koPieSlice, (List)Nil$.MODULE$)), (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$)));
        return (Component)componentFactory.apply((Object)BoxesRunTime.boxToLong((long)this.reportsGenerationInputs.logFileData().runInfo().injectStart()), countsSeries, pieRequestsSeries);
    }

    private final Component responseTimeScatterChartComponent$1(String requestName$1, Option group$1) {
        return RequestDetailsReportGenerator.scatterChartComponent$1((Function3 & Serializable)(status, requestName, group) -> $this.reportsGenerationInputs.logFileData().responseTimeAgainstGlobalNumberOfRequestsPerSec((Status)status, (String)requestName, (Option<Group>)group), (Function2 & Serializable)(successData, failuresData) -> $this.componentLibrary.getResponseTimeScatterComponent((Series<IntVsTimePlot>)successData, (Series<IntVsTimePlot>)failuresData), requestName$1, group$1);
    }

    private static final Component scatterChartComponent$1(Function3 dataSource, Function2 componentFactory, String requestName$1, Option group$1) {
        Seq scatterPlotSuccessData = (Seq)dataSource.apply((Object)OK$.MODULE$, (Object)requestName$1, (Object)group$1);
        Seq scatterPlotFailuresData = (Seq)dataSource.apply((Object)KO$.MODULE$, (Object)requestName$1, (Object)group$1);
        Series scatterPlotSuccessSeries = new Series(Series$.MODULE$.OK(), scatterPlotSuccessData, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ok(), (List)Nil$.MODULE$));
        Series scatterPlotFailuresSeries = new Series(Series$.MODULE$.KO(), scatterPlotFailuresData, (List<Color>)new .colon.colon((Object)Color$Requests$.MODULE$.Ko(), (List)Nil$.MODULE$));
        return (Component)componentFactory.apply(scatterPlotSuccessSeries, scatterPlotFailuresSeries);
    }

    private final void generateDetailPage$1(String path, String requestName, Option group) {
        RequestDetailsPageTemplate template = new RequestDetailsPageTemplate(this.reportsGenerationInputs.logFileData().runInfo(), path, requestName, (Option<Group>)group, (Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{new SchemaContainerComponent((Seq<Component>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{this.componentLibrary.getRangesComponent("Response Time Ranges", "requests", true), new DetailsStatsTableComponent(this.configuration)})), new ErrorsTableComponent(this.reportsGenerationInputs.logFileData().errors((Option<String>)new Some((Object)requestName), (Option<Group>)group)), this.responseTimeDistributionChartComponent$1(requestName, group), this.responseTimeChartComponent$1(requestName, group), this.requestsChartComponent$1(requestName, group), this.responsesChartComponent$1(requestName, group), this.responseTimeScatterChartComponent$1(requestName, group)}));
        new TemplateWriter(this.chartsFiles.requestFile(path)).writeToFile(template.getOutput(this.configuration.core().charset()), this.configuration);
    }

    public static final /* synthetic */ void $anonfun$generate$10(RequestDetailsReportGenerator $this, StatsPath x0$1) {
        StatsPath statsPath = x0$1;
        if (statsPath instanceof RequestStatsPath) {
            RequestStatsPath requestStatsPath = (RequestStatsPath)statsPath;
            String request = requestStatsPath.request();
            Option group = requestStatsPath.group();
            $this.generateDetailPage$1(RequestPath$.MODULE$.path(request, (Option<Group>)group), request, group);
            return;
        }
    }

    public RequestDetailsReportGenerator(ReportsGenerationInputs reportsGenerationInputs, ChartsFiles chartsFiles, ComponentLibrary componentLibrary, GatlingConfiguration configuration) {
        this.reportsGenerationInputs = reportsGenerationInputs;
        this.chartsFiles = chartsFiles;
        this.componentLibrary = componentLibrary;
        this.configuration = configuration;
    }
}

