/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.hmac;

import io.fusionauth.jwt.InvalidJWTSignatureException;
import io.fusionauth.jwt.JWTVerifierException;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.Algorithm;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACVerifier
implements Verifier {
    private final byte[] secret;

    private HMACVerifier(String secret) {
        Objects.requireNonNull(secret);
        this.secret = secret.getBytes(StandardCharsets.UTF_8);
    }

    private HMACVerifier(byte[] secret) {
        Objects.requireNonNull(secret);
        this.secret = secret;
    }

    public static HMACVerifier newVerifier(String secret) {
        Objects.requireNonNull(secret);
        return new HMACVerifier(secret);
    }

    public static HMACVerifier newVerifier(Path path) {
        Objects.requireNonNull(path);
        try {
            return new HMACVerifier(Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new JWTVerifierException("Unable to read the file from path [" + String.valueOf(path.toAbsolutePath()) + "]", e);
        }
    }

    public static HMACVerifier newVerifier(byte[] bytes) {
        Objects.requireNonNull(bytes);
        return new HMACVerifier(bytes);
    }

    @Override
    public boolean canVerify(Algorithm algorithm) {
        return switch (algorithm) {
            case Algorithm.HS256, Algorithm.HS384, Algorithm.HS512 -> true;
            default -> false;
        };
    }

    @Override
    public void verify(Algorithm algorithm, byte[] message, byte[] signature) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(message);
        Objects.requireNonNull(signature);
        try {
            Mac mac = Mac.getInstance(algorithm.getName());
            mac.init(new SecretKeySpec(this.secret, algorithm.getName()));
            byte[] actualSignature = mac.doFinal(message);
            if (!MessageDigest.isEqual(signature, actualSignature)) {
                throw new InvalidJWTSignatureException();
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new JWTVerifierException("An unexpected exception occurred when attempting to verify the JWT", e);
        }
    }
}

