/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwks;

import io.fusionauth.jwks.JSONWebKeyParserException;
import io.fusionauth.jwks.JWKUtils;
import io.fusionauth.jwks.domain.JSONWebKey;
import io.fusionauth.jwt.domain.KeyType;
import io.fusionauth.pem.PEMEncoder;
import io.fusionauth.pem.domain.PEM;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EdECPoint;
import java.security.spec.EdECPublicKeySpec;
import java.security.spec.NamedParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Objects;

public class JSONWebKeyParser {
    public PublicKey parse(JSONWebKey key) {
        Objects.requireNonNull(key);
        try {
            if (key.kty == KeyType.RSA) {
                BigInteger modulus = JWKUtils.base64DecodeUint(key.n);
                BigInteger publicExponent = JWKUtils.base64DecodeUint(key.e);
                PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
                if (key.x5c != null && key.x5c.size() > 0) {
                    this.verifyX5cRSA(key, modulus, publicExponent);
                }
                return publicKey;
            }
            if (key.kty == KeyType.EC) {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
                switch (key.crv) {
                    case "P-256": {
                        parameters.init(new ECGenParameterSpec("secp256r1"));
                        break;
                    }
                    case "P-384": {
                        parameters.init(new ECGenParameterSpec("secp384r1"));
                        break;
                    }
                    case "P-521": {
                        parameters.init(new ECGenParameterSpec("secp521r1"));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported EC algorithm. Support algorithms include P-256, P-384 and P-521.");
                    }
                }
                ECParameterSpec ecParameterSpec = parameters.getParameterSpec(ECParameterSpec.class);
                BigInteger xCoordinate = JWKUtils.base64DecodeUint(key.x);
                BigInteger yCoordinate = JWKUtils.base64DecodeUint(key.y);
                ECPoint ecPoint = new ECPoint(xCoordinate, yCoordinate);
                PublicKey publicKey = KeyFactory.getInstance("EC").generatePublic(new ECPublicKeySpec(ecPoint, ecParameterSpec));
                if (key.x5c != null && key.x5c.size() > 0) {
                    this.verifyX5cEC(key, xCoordinate, yCoordinate);
                }
                return publicKey;
            }
            if (key.kty == KeyType.OKP) {
                if (!"Ed25519".equals(key.crv) && !"Ed448".equals(key.crv)) {
                    throw new UnsupportedOperationException("Only a Ed25519 or Ed448 OKP JSON Web key may be parsed.");
                }
                byte[] bytes = Base64.getUrlDecoder().decode(key.x);
                this.reverseArray(bytes);
                int lastBit = bytes[0] & 0xFF;
                boolean xOdd = (lastBit & 0x80) == 128;
                bytes[0] = (byte)(lastBit & 0x7F);
                BigInteger y = new BigInteger(1, bytes);
                EdECPublicKeySpec keySpec = new EdECPublicKeySpec(new NamedParameterSpec(key.crv), new EdECPoint(xOdd, y));
                return KeyFactory.getInstance(key.crv).generatePublic(keySpec);
            }
        }
        catch (JSONWebKeyParserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JSONWebKeyParserException("Failed to parse the provided JSON Web Key", e);
        }
        throw new UnsupportedOperationException("Only RSA, EC or OKP JSON Web Keys may be parsed.");
    }

    private void verifyX5cEC(JSONWebKey key, BigInteger expectedXCoordinate, BigInteger expectedYCoordinate) {
        String encodedCertificate = key.x5c.get(0);
        String pem = new PEMEncoder().parseEncodedCertificate(encodedCertificate);
        PublicKey actual = PEM.decode((String)pem).publicKey;
        if (!(actual instanceof ECPublicKey)) {
            throw new JSONWebKeyParserException("The public key found in the [x5c] property does not match the expected key type specified by the [kty] property.");
        }
        ECPublicKey ecPublicKey = (ECPublicKey)actual;
        ECPoint point = ecPublicKey.getW();
        if (!point.getAffineX().equals(expectedXCoordinate)) {
            throw new JSONWebKeyParserException("Expected an x coordinate value of [" + String.valueOf(expectedXCoordinate) + "] but found [" + String.valueOf(point.getAffineX()) + "].  The certificate found in [x5c] does not match the [x] coordinate property.");
        }
        if (!point.getAffineY().equals(expectedYCoordinate)) {
            throw new JSONWebKeyParserException("Expected a y coordinate value of [" + String.valueOf(expectedYCoordinate) + "] but found [" + String.valueOf(point.getAffineY()) + "].  The certificate found in [x5c] does not match the [y] coordinate property.");
        }
    }

    private void reverseArray(byte[] arr) {
        int i = 0;
        for (int j = arr.length - 1; i < j; ++i, --j) {
            byte tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
        }
    }

    private void verifyX5cRSA(JSONWebKey key, BigInteger expectedModulus, BigInteger expectedPublicExponent) {
        String encodedCertificate = key.x5c.get(0);
        String pem = new PEMEncoder().parseEncodedCertificate(encodedCertificate);
        PublicKey actual = PEM.decode((String)pem).publicKey;
        if (!(actual instanceof RSAPublicKey)) {
            throw new JSONWebKeyParserException("The public key found in the [x5c] property does not match the expected key type specified by the [kty] property.");
        }
        RSAPublicKey rsaPublicKey = (RSAPublicKey)actual;
        if (!rsaPublicKey.getModulus().equals(expectedModulus)) {
            throw new JSONWebKeyParserException("Expected a modulus value of [" + String.valueOf(expectedModulus) + "] but found [" + String.valueOf(rsaPublicKey.getModulus()) + "].  The certificate found in [x5c] does not match the [n] property.");
        }
        if (!rsaPublicKey.getPublicExponent().equals(expectedPublicExponent)) {
            throw new JSONWebKeyParserException("Expected a public exponent value of [" + String.valueOf(expectedPublicExponent) + "] but found [" + String.valueOf(rsaPublicKey.getPublicExponent()) + "].  The certificate found in [x5c] does not match the [e] property.");
        }
    }
}

