/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.der;

import io.fusionauth.der.TagClass;
import java.util.Objects;

public class Tag {
    public static final int BitString = 3;
    public static final int Integer = 2;
    public static final int Null = 5;
    public static final int ObjectIdentifier = 6;
    public static final int OctetString = 4;
    public static final int PrintableString = 19;
    public static final int Sequence = 48;
    public static final int Set = 17;
    public static final int UTCTime = 23;
    public final boolean primitive;
    public final byte rawByte;
    public final TagClass tagClass;
    public final int value;

    public Tag(int value) {
        this.rawByte = (byte)value;
        this.tagClass = this.setTagClass(value);
        this.primitive = (this.rawByte & 0x20) == 0;
        this.value = value & 0x1F;
    }

    static String hexString(int value) {
        return "0x" + String.format("%02x", value).toUpperCase();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)o;
        return this.rawByte == tag.rawByte;
    }

    public String getName() {
        return switch (this.rawByte) {
            case 2 -> "Integer";
            case 3 -> "Bit String";
            case 5 -> "Null";
            case 6 -> "Object Identifier";
            case 4 -> "Octet String";
            case 19 -> "PrintableString";
            case 48 -> "Sequence";
            case 17 -> "Set";
            case 23 -> "UTCTime";
            default -> "Other";
        };
    }

    public int hashCode() {
        return Objects.hash(this.rawByte);
    }

    public boolean is(int tag) {
        return this.value == (tag & 0x1F);
    }

    public boolean isConstructed() {
        return !this.primitive;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public String toString() {
        if (this.tagClass == TagClass.ContextSpecific) {
            return "[" + this.value + "]";
        }
        return this.value + " [" + this.getName() + ", " + this.hexString() + "]";
    }

    private TagClass setTagClass(int value) {
        TagClass tagClass = null;
        for (TagClass tc : TagClass.values()) {
            if ((value & 0xC0) != tc.value) continue;
            tagClass = tc;
            break;
        }
        if (tagClass == null) {
            throw new IllegalArgumentException("Invalid tag value " + value + ", the tag does not appear to fit into one of the expected classes");
        }
        return tagClass;
    }

    String hexString() {
        return "0x" + String.format("%02x", this.value).toUpperCase();
    }
}

