/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.ec;

import io.fusionauth.jwt.InvalidKeyTypeException;
import io.fusionauth.jwt.JWTSigningException;
import io.fusionauth.jwt.MissingPrivateKeyException;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.ec.ECDSASignature;
import io.fusionauth.pem.domain.PEM;
import io.fusionauth.security.CryptoProvider;
import io.fusionauth.security.DefaultCryptoProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.util.Objects;

public class ECSigner
implements Signer {
    private final Algorithm algorithm;
    private final String kid;
    private final ECPrivateKey privateKey;
    private final CryptoProvider cryptoProvider;

    private ECSigner(Algorithm algorithm, PrivateKey privateKey, String kid, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(cryptoProvider);
        Objects.requireNonNull(privateKey);
        this.algorithm = algorithm;
        this.cryptoProvider = cryptoProvider;
        this.kid = kid;
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyTypeException("Expecting a private key of type [ECPrivateKey], but found [" + privateKey.getClass().getSimpleName() + "].");
        }
        this.privateKey = (ECPrivateKey)privateKey;
    }

    private ECSigner(Algorithm algorithm, String privateKey, String kid, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(cryptoProvider);
        Objects.requireNonNull(privateKey);
        this.algorithm = algorithm;
        this.cryptoProvider = cryptoProvider;
        this.kid = kid;
        PEM pem = PEM.decode(privateKey);
        if (pem.privateKey == null) {
            throw new MissingPrivateKeyException("The provided PEM encoded string did not contain a private key.");
        }
        if (!(pem.privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyTypeException("Expecting a private key of type [ECPrivateKey], but found [" + pem.privateKey.getClass().getSimpleName() + "].");
        }
        this.privateKey = (ECPrivateKey)pem.getPrivateKey();
    }

    public static ECSigner newSHA256Signer(String privateKey) {
        return new ECSigner(Algorithm.ES256, privateKey, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECSigner newSHA256Signer(String privateKey, String kid) {
        return new ECSigner(Algorithm.ES256, privateKey, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECSigner newSHA256Signer(String privateKey, CryptoProvider cryptoProvider) {
        return new ECSigner(Algorithm.ES256, privateKey, null, cryptoProvider);
    }

    public static ECSigner newSHA256Signer(String privateKey, String kid, CryptoProvider cryptoProvider) {
        return new ECSigner(Algorithm.ES256, privateKey, kid, cryptoProvider);
    }

    public static ECSigner newSHA256Signer(PrivateKey privateKey) {
        return new ECSigner(Algorithm.ES256, privateKey, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECSigner newSHA256Signer(PrivateKey privateKey, String kid) {
        return new ECSigner(Algorithm.ES256, privateKey, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECSigner newSHA256Signer(PrivateKey privateKey, CryptoProvider cryptoProvider) {
        return new ECSigner(Algorithm.ES256, privateKey, null, cryptoProvider);
    }

    public static ECSigner newSHA256Signer(PrivateKey privateKey, String kid, CryptoProvider cryptoProvider) {
        return new ECSigner(Algorithm.ES256, privateKey, kid, cryptoProvider);
    }

    public static ECSigner newSHA384Signer(String privateKey) {
        return new ECSigner(Algorithm.ES384, privateKey, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECSigner newSHA384Signer(String privateKey, String kid) {
        return new ECSigner(Algorithm.ES384, privateKey, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECSigner newSHA384Signer(String privateKey, CryptoProvider cryptoProvider) {
        return new ECSigner(Algorithm.ES384, privateKey, null, cryptoProvider);
    }

    public static ECSigner newSHA384Signer(String privateKey, String kid, CryptoProvider cryptoProvider) {
        return new ECSigner(Algorithm.ES384, privateKey, kid, cryptoProvider);
    }

    public static ECSigner newSHA384Signer(PrivateKey privateKey) {
        return new ECSigner(Algorithm.ES384, privateKey, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECSigner newSHA384Signer(PrivateKey privateKey, String kid) {
        return new ECSigner(Algorithm.ES384, privateKey, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECSigner newSHA384Signer(PrivateKey privateKey, CryptoProvider cryptoProvider) {
        return new ECSigner(Algorithm.ES384, privateKey, null, cryptoProvider);
    }

    public static ECSigner newSHA384Signer(PrivateKey privateKey, String kid, CryptoProvider cryptoProvider) {
        return new ECSigner(Algorithm.ES384, privateKey, kid, cryptoProvider);
    }

    public static ECSigner newSHA512Signer(String privateKey) {
        return new ECSigner(Algorithm.ES512, privateKey, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECSigner newSHA512Signer(String privateKey, String kid) {
        return new ECSigner(Algorithm.ES512, privateKey, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECSigner newSHA512Signer(String privateKey, CryptoProvider cryptoProvider) {
        return new ECSigner(Algorithm.ES512, privateKey, null, cryptoProvider);
    }

    public static ECSigner newSHA512Signer(String privateKey, String kid, CryptoProvider cryptoProvider) {
        return new ECSigner(Algorithm.ES512, privateKey, kid, cryptoProvider);
    }

    public static ECSigner newSHA512Signer(PrivateKey privateKey) {
        return new ECSigner(Algorithm.ES512, privateKey, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECSigner newSHA512Signer(PrivateKey privateKey, String kid) {
        return new ECSigner(Algorithm.ES512, privateKey, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static ECSigner newSHA512Signer(PrivateKey privateKey, CryptoProvider cryptoProvider) {
        return new ECSigner(Algorithm.ES512, privateKey, null, cryptoProvider);
    }

    public static ECSigner newSHA512Signer(PrivateKey privateKey, String kid, CryptoProvider cryptoProvider) {
        return new ECSigner(Algorithm.ES512, privateKey, kid, cryptoProvider);
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getKid() {
        return this.kid;
    }

    @Override
    public byte[] sign(String message) {
        Objects.requireNonNull(message);
        try {
            Signature signature = this.cryptoProvider.getSignatureInstance(this.algorithm.getName());
            signature.initSign(this.privateKey);
            signature.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] derEncoded = signature.sign();
            return new ECDSASignature(derEncoded).derDecode(this.algorithm);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTSigningException("An unexpected exception occurred when attempting to sign the JWT", e);
        }
    }
}

