/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.rsa;

import io.fusionauth.jwt.InvalidKeyLengthException;
import io.fusionauth.jwt.InvalidKeyTypeException;
import io.fusionauth.jwt.JWTSigningException;
import io.fusionauth.jwt.MissingPrivateKeyException;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.pem.domain.PEM;
import io.fusionauth.security.CryptoProvider;
import io.fusionauth.security.DefaultCryptoProvider;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Objects;

public class RSAPSSSigner
implements Signer {
    private final Algorithm algorithm;
    private final CryptoProvider cryptoProvider;
    private final String kid;
    private final RSAPrivateKey privateKey;

    private RSAPSSSigner(Algorithm algorithm, PrivateKey privateKey, String kid, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(cryptoProvider);
        Objects.requireNonNull(privateKey);
        this.algorithm = algorithm;
        this.cryptoProvider = cryptoProvider;
        this.kid = kid;
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyTypeException("Expecting a private key of type [RSAPrivateKey], but found [" + privateKey.getClass().getSimpleName() + "].");
        }
        this.privateKey = (RSAPrivateKey)privateKey;
        int keyLength = this.privateKey.getModulus().bitLength();
        if (keyLength < 2048) {
            throw new InvalidKeyLengthException("Key length of [" + keyLength + "] is less than the required key length of 2048 bits.");
        }
    }

    private RSAPSSSigner(Algorithm algorithm, String privateKey, String kid, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(cryptoProvider);
        Objects.requireNonNull(privateKey);
        this.algorithm = algorithm;
        this.cryptoProvider = cryptoProvider;
        this.kid = kid;
        PEM pem = PEM.decode(privateKey);
        if (pem.privateKey == null) {
            throw new MissingPrivateKeyException("The provided PEM encoded string did not contain a private key.");
        }
        if (!(pem.privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyTypeException("Expecting a private key of type [RSAPrivateKey], but found [" + pem.privateKey.getClass().getSimpleName() + "].");
        }
        this.privateKey = (RSAPrivateKey)pem.getPrivateKey();
        int keyLength = this.privateKey.getModulus().bitLength();
        if (keyLength < 2048) {
            throw new InvalidKeyLengthException("Key length of [" + keyLength + "] is less than the required key length of 2048 bits.");
        }
    }

    public static RSAPSSSigner newSHA256Signer(String privateKey) {
        return new RSAPSSSigner(Algorithm.PS256, privateKey, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSSigner newSHA256Signer(String privateKey, String kid) {
        return new RSAPSSSigner(Algorithm.PS256, privateKey, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSSigner newSHA256Signer(String privateKey, CryptoProvider cryptoProvider) {
        return new RSAPSSSigner(Algorithm.PS256, privateKey, null, cryptoProvider);
    }

    public static RSAPSSSigner newSHA256Signer(String privateKey, String kid, CryptoProvider cryptoProvider) {
        return new RSAPSSSigner(Algorithm.PS256, privateKey, kid, cryptoProvider);
    }

    public static RSAPSSSigner newSHA256Signer(PrivateKey privateKey) {
        return new RSAPSSSigner(Algorithm.PS256, privateKey, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSSigner newSHA256Signer(PrivateKey privateKey, String kid) {
        return new RSAPSSSigner(Algorithm.PS256, privateKey, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSSigner newSHA256Signer(PrivateKey privateKey, CryptoProvider cryptoProvider) {
        return new RSAPSSSigner(Algorithm.PS256, privateKey, null, cryptoProvider);
    }

    public static RSAPSSSigner newSHA256Signer(PrivateKey privateKey, String kid, CryptoProvider cryptoProvider) {
        return new RSAPSSSigner(Algorithm.PS256, privateKey, kid, cryptoProvider);
    }

    public static RSAPSSSigner newSHA384Signer(String privateKey) {
        return new RSAPSSSigner(Algorithm.PS384, privateKey, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSSigner newSHA384Signer(String privateKey, String kid) {
        return new RSAPSSSigner(Algorithm.PS384, privateKey, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSSigner newSHA384Signer(String privateKey, CryptoProvider cryptoProvider) {
        return new RSAPSSSigner(Algorithm.PS384, privateKey, null, cryptoProvider);
    }

    public static RSAPSSSigner newSHA384Signer(String privateKey, String kid, CryptoProvider cryptoProvider) {
        return new RSAPSSSigner(Algorithm.PS384, privateKey, kid, cryptoProvider);
    }

    public static RSAPSSSigner newSHA384Signer(PrivateKey privateKey) {
        return new RSAPSSSigner(Algorithm.PS384, privateKey, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSSigner newSHA384Signer(PrivateKey privateKey, String kid) {
        return new RSAPSSSigner(Algorithm.PS384, privateKey, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSSigner newSHA384Signer(PrivateKey privateKey, CryptoProvider cryptoProvider) {
        return new RSAPSSSigner(Algorithm.PS384, privateKey, null, cryptoProvider);
    }

    public static RSAPSSSigner newSHA384Signer(PrivateKey privateKey, String kid, CryptoProvider cryptoProvider) {
        return new RSAPSSSigner(Algorithm.PS384, privateKey, kid, cryptoProvider);
    }

    public static RSAPSSSigner newSHA512Signer(String privateKey) {
        return new RSAPSSSigner(Algorithm.PS512, privateKey, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSSigner newSHA512Signer(String privateKey, String kid) {
        return new RSAPSSSigner(Algorithm.PS512, privateKey, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSSigner newSHA512Signer(String privateKey, CryptoProvider cryptoProvider) {
        return new RSAPSSSigner(Algorithm.PS512, privateKey, null, cryptoProvider);
    }

    public static RSAPSSSigner newSHA512Signer(String privateKey, String kid, CryptoProvider cryptoProvider) {
        return new RSAPSSSigner(Algorithm.PS512, privateKey, kid, cryptoProvider);
    }

    public static RSAPSSSigner newSHA512Signer(PrivateKey privateKey) {
        return new RSAPSSSigner(Algorithm.PS512, privateKey, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSSigner newSHA512Signer(PrivateKey privateKey, String kid) {
        return new RSAPSSSigner(Algorithm.PS512, privateKey, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static RSAPSSSigner newSHA512Signer(PrivateKey privateKey, CryptoProvider cryptoProvider) {
        return new RSAPSSSigner(Algorithm.PS512, privateKey, null, cryptoProvider);
    }

    public static RSAPSSSigner newSHA512Signer(PrivateKey privateKey, String kid, CryptoProvider cryptoProvider) {
        return new RSAPSSSigner(Algorithm.PS512, privateKey, kid, cryptoProvider);
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getKid() {
        return this.kid;
    }

    @Override
    public byte[] sign(String message) {
        Objects.requireNonNull(message);
        try {
            Signature signature = this.cryptoProvider.getSignatureInstance("RSASSA-PSS");
            signature.setParameter(new PSSParameterSpec(this.algorithm.getName(), "MGF1", new MGF1ParameterSpec(this.algorithm.getName()), this.algorithm.getSaltLength(), 1));
            signature.initSign(this.privateKey);
            signature.update(message.getBytes(StandardCharsets.UTF_8));
            return signature.sign();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTSigningException("An unexpected exception occurred when attempting to sign the JWT", e);
        }
    }
}

