/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.hmac;

import io.fusionauth.jwt.JWTSigningException;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.security.CryptoProvider;
import io.fusionauth.security.DefaultCryptoProvider;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACSigner
implements Signer {
    private final Algorithm algorithm;
    private final String kid;
    private final CryptoProvider cryptoProvider;
    private final byte[] secret;

    private HMACSigner(Algorithm algorithm, byte[] secret, String kid, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(cryptoProvider);
        Objects.requireNonNull(secret);
        this.algorithm = algorithm;
        this.cryptoProvider = cryptoProvider;
        this.kid = kid;
        this.secret = secret;
    }

    private HMACSigner(Algorithm algorithm, String secret, String kid, CryptoProvider cryptoProvider) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(cryptoProvider);
        Objects.requireNonNull(secret);
        this.algorithm = algorithm;
        this.cryptoProvider = cryptoProvider;
        this.kid = kid;
        this.secret = secret.getBytes(StandardCharsets.UTF_8);
    }

    public static HMACSigner newSHA256Signer(byte[] secret) {
        return HMACSigner.newSHA256Signer(secret, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACSigner newSHA256Signer(String secret) {
        return HMACSigner.newSHA256Signer(secret, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACSigner newSHA256Signer(byte[] secret, String kid) {
        return HMACSigner.newSHA256Signer(secret, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACSigner newSHA256Signer(String secret, String kid) {
        return HMACSigner.newSHA256Signer(secret, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACSigner newSHA256Signer(String secret, CryptoProvider cryptoProvider) {
        return HMACSigner.newSHA256Signer(secret, null, cryptoProvider);
    }

    public static HMACSigner newSHA256Signer(byte[] secret, String kid, CryptoProvider cryptoProvider) {
        return new HMACSigner(Algorithm.HS256, secret, kid, cryptoProvider);
    }

    public static HMACSigner newSHA256Signer(String secret, String kid, CryptoProvider cryptoProvider) {
        return new HMACSigner(Algorithm.HS256, secret, kid, cryptoProvider);
    }

    public static HMACSigner newSHA384Signer(byte[] secret) {
        return HMACSigner.newSHA384Signer(secret, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACSigner newSHA384Signer(String secret) {
        return HMACSigner.newSHA384Signer(secret, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACSigner newSHA384Signer(byte[] secret, String kid) {
        return HMACSigner.newSHA384Signer(secret, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACSigner newSHA384Signer(String secret, String kid) {
        return HMACSigner.newSHA384Signer(secret, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACSigner newSHA384Signer(String secret, CryptoProvider cryptoProvider) {
        return HMACSigner.newSHA384Signer(secret, null, cryptoProvider);
    }

    public static HMACSigner newSHA384Signer(byte[] secret, String kid, CryptoProvider cryptoProvider) {
        return new HMACSigner(Algorithm.HS384, secret, kid, cryptoProvider);
    }

    public static HMACSigner newSHA384Signer(String secret, String kid, CryptoProvider cryptoProvider) {
        return new HMACSigner(Algorithm.HS384, secret, kid, cryptoProvider);
    }

    public static HMACSigner newSHA512Signer(byte[] secret) {
        return HMACSigner.newSHA512Signer(secret, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACSigner newSHA512Signer(String secret) {
        return HMACSigner.newSHA512Signer(secret, null, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACSigner newSHA512Signer(byte[] secret, String kid) {
        return HMACSigner.newSHA512Signer(secret, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACSigner newSHA512Signer(String secret, String kid) {
        return HMACSigner.newSHA512Signer(secret, kid, (CryptoProvider)new DefaultCryptoProvider());
    }

    public static HMACSigner newSHA512Signer(String secret, CryptoProvider cryptoProvider) {
        return HMACSigner.newSHA512Signer(secret, null, cryptoProvider);
    }

    public static HMACSigner newSHA512Signer(byte[] secret, String kid, CryptoProvider cryptoProvider) {
        return new HMACSigner(Algorithm.HS512, secret, kid, cryptoProvider);
    }

    public static HMACSigner newSHA512Signer(String secret, String kid, CryptoProvider cryptoProvider) {
        return new HMACSigner(Algorithm.HS512, secret, kid, cryptoProvider);
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getKid() {
        return this.kid;
    }

    @Override
    public byte[] sign(String message) {
        Objects.requireNonNull(message);
        try {
            Mac mac = this.cryptoProvider.getMacInstance(this.algorithm.getName());
            mac.init(new SecretKeySpec(this.secret, this.algorithm.getName()));
            return mac.doFinal(message.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new JWTSigningException("An unexpected exception occurred when attempting to sign the JWT", e);
        }
    }
}

