/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.der;

import io.fusionauth.der.DerEncodingException;
import io.fusionauth.der.DerValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DerOutputStream {
    private final ByteArrayOutputStream os = new ByteArrayOutputStream();

    public byte[] toByteArray() {
        return this.os.toByteArray();
    }

    public DerOutputStream writeValue(DerValue value) throws DerEncodingException {
        try {
            this.os.write(value.tag.rawByte);
            this.writeLength(value.getLength());
            this.os.write(value.toByteArray());
            return this;
        }
        catch (IOException e) {
            throw new DerEncodingException(e);
        }
    }

    private void writeLength(int length) {
        if (length < 128) {
            this.os.write((byte)length);
        } else if (length < 256) {
            this.os.write(-127);
            this.os.write((byte)length);
        } else if (length < 65536) {
            this.os.write(-126);
            this.os.write((byte)(length >> 8));
            this.os.write((byte)length);
        } else if (length < 0x1000000) {
            this.os.write(-125);
            this.os.write((byte)(length >> 16));
            this.os.write((byte)(length >> 8));
            this.os.write((byte)length);
        } else {
            this.os.write(-124);
            this.os.write((byte)(length >> 24));
            this.os.write((byte)(length >> 16));
            this.os.write((byte)(length >> 8));
            this.os.write((byte)length);
        }
    }
}

