/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.jwks.JSONWebKeySetHelper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class AbstractHttpHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static <T> T get(HttpURLConnection urlConnection, Function<InputStream, T> consumer, BiFunction<String, Throwable, ? extends RuntimeException> exception) {
        int status;
        String endpoint = urlConnection.getURL().toString();
        try {
            urlConnection.setRequestMethod("GET");
            urlConnection.connect();
        }
        catch (Exception e) {
            throw exception.apply("Failed to connect to [" + endpoint + "].", e);
        }
        try {
            status = urlConnection.getResponseCode();
        }
        catch (Exception e) {
            throw exception.apply("Failed to make a request to [" + endpoint + "].", e);
        }
        if (status < 200) throw exception.apply("Failed to make a request to [" + endpoint + "], a status code of [" + status + "] was returned.", null);
        if (status > 299) {
            throw exception.apply("Failed to make a request to [" + endpoint + "], a status code of [" + status + "] was returned.", null);
        }
        try (BufferedInputStream is = new BufferedInputStream(urlConnection.getInputStream());){
            InputStream inputStream = consumer.apply(is);
            return (T)inputStream;
        }
        catch (Exception e) {
            throw exception.apply("Failed to parse the response as JSON from [" + endpoint + "].", e);
        }
    }

    protected static HttpURLConnection buildURLConnection(String endpoint) {
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(endpoint).openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setConnectTimeout(10000);
            urlConnection.setReadTimeout(10000);
            urlConnection.addRequestProperty("User-Agent", "fusionauth-jwt (https://github.com/FusionAuth/fusionauth-jwt)");
            return urlConnection;
        }
        catch (IOException e) {
            throw new JSONWebKeySetHelper.JSONWebKeySetException("Failed to build connection to [" + endpoint + "].", e);
        }
    }
}

