/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.domain;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fusionauth.jwt.JWTDecoder;
import io.fusionauth.jwt.JWTEncoder;
import io.fusionauth.jwt.json.Mapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JWT {
    @JsonProperty(value="aud")
    public Object audience;
    @JsonProperty(value="exp")
    public ZonedDateTime expiration;
    @JsonProperty(value="iat")
    public ZonedDateTime issuedAt;
    @JsonProperty(value="iss")
    public String issuer;
    @JsonProperty(value="nbf")
    public ZonedDateTime notBefore;
    @JsonAnySetter
    public Map<String, Object> otherClaims = new LinkedHashMap<String, Object>();
    @JsonProperty(value="sub")
    public String subject;
    @JsonProperty(value="jti")
    public String uniqueId;

    public static JWTDecoder getDecoder() {
        return new JWTDecoder();
    }

    public static JWTEncoder getEncoder() {
        return new JWTEncoder();
    }

    public JWT addClaim(String name, Object value) {
        if (value == null) {
            return this;
        }
        switch (name) {
            case "aud": {
                this.audience = value;
                break;
            }
            case "exp": {
                this.expiration = this.toZonedDateTime("exp", value);
                break;
            }
            case "iat": {
                this.issuedAt = this.toZonedDateTime("iat", value);
                break;
            }
            case "iss": {
                this.issuer = (String)value;
                break;
            }
            case "jti": {
                this.uniqueId = (String)value;
                break;
            }
            case "nbf": {
                this.notBefore = this.toZonedDateTime("nbf", value);
                break;
            }
            case "sub": {
                this.subject = (String)value;
                break;
            }
            default: {
                if (value instanceof Double || value instanceof Float) {
                    value = BigDecimal.valueOf(((Number)value).doubleValue());
                } else if (value instanceof Integer || value instanceof Long) {
                    value = BigInteger.valueOf(((Number)value).longValue());
                }
                this.otherClaims.put(name, value);
            }
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWT jwt = (JWT)o;
        return Objects.equals(this.audience, jwt.audience) && Objects.equals(this.otherClaims, jwt.otherClaims) && Objects.equals(this.expiration, jwt.expiration) && Objects.equals(this.issuedAt, jwt.issuedAt) && Objects.equals(this.issuer, jwt.issuer) && Objects.equals(this.notBefore, jwt.notBefore) && Objects.equals(this.subject, jwt.subject) && Objects.equals(this.uniqueId, jwt.uniqueId);
    }

    @JsonIgnore
    public Map<String, Object> getAllClaims() {
        HashMap<String, Object> rawClaims = new HashMap<String, Object>(this.otherClaims);
        if (this.audience != null) {
            rawClaims.put("aud", this.audience);
        }
        if (this.expiration != null) {
            rawClaims.put("exp", this.expiration);
        }
        if (this.issuedAt != null) {
            rawClaims.put("iat", this.issuedAt);
        }
        if (this.issuer != null) {
            rawClaims.put("iss", this.issuer);
        }
        if (this.notBefore != null) {
            rawClaims.put("nbf", this.notBefore);
        }
        if (this.subject != null) {
            rawClaims.put("sub", this.subject);
        }
        if (this.uniqueId != null) {
            rawClaims.put("jti", this.uniqueId);
        }
        return rawClaims;
    }

    public BigDecimal getBigDecimal(String key) {
        return (BigDecimal)this.lookupClaim(key);
    }

    public BigInteger getBigInteger(String key) {
        return (BigInteger)this.lookupClaim(key);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.lookupClaim(key);
    }

    public Double getDouble(String key) {
        BigDecimal value = (BigDecimal)this.lookupClaim(key);
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    public Float getFloat(String key) {
        BigDecimal value = (BigDecimal)this.lookupClaim(key);
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.floatValue());
    }

    public Integer getInteger(String key) {
        BigInteger value = (BigInteger)this.lookupClaim(key);
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    public List<Object> getList(String key) {
        return (List)this.otherClaims.get(key);
    }

    public Long getLong(String key) {
        BigInteger value = (BigInteger)this.lookupClaim(key);
        if (value == null) {
            return null;
        }
        return value.longValue();
    }

    public Map<String, Object> getMap(String key) {
        return (Map)this.lookupClaim(key);
    }

    public Number getNumber(String key) {
        return (Number)this.lookupClaim(key);
    }

    public Object getObject(String key) {
        return this.lookupClaim(key);
    }

    @JsonAnyGetter
    public Map<String, Object> getOtherClaims() {
        return this.otherClaims;
    }

    @JsonIgnore
    public Map<String, Object> getRawClaims() {
        HashMap<String, Object> rawClaims = new HashMap<String, Object>(this.otherClaims);
        if (this.audience != null) {
            rawClaims.put("aud", this.audience);
        }
        if (this.expiration != null) {
            rawClaims.put("exp", this.expiration.toEpochSecond());
        }
        if (this.issuedAt != null) {
            rawClaims.put("iat", this.issuedAt.toEpochSecond());
        }
        if (this.issuer != null) {
            rawClaims.put("iss", this.issuer);
        }
        if (this.notBefore != null) {
            rawClaims.put("nbf", this.notBefore.toEpochSecond());
        }
        if (this.subject != null) {
            rawClaims.put("sub", this.subject);
        }
        if (this.uniqueId != null) {
            rawClaims.put("jti", this.uniqueId);
        }
        return rawClaims;
    }

    public String getString(String key) {
        return (String)this.lookupClaim(key);
    }

    public int hashCode() {
        return Objects.hash(this.audience, this.otherClaims, this.expiration, this.issuedAt, this.issuer, this.notBefore, this.subject, this.uniqueId);
    }

    @JsonIgnore
    public boolean isExpired() {
        return this.expiration != null && this.expiration.isBefore(ZonedDateTime.now(ZoneOffset.UTC));
    }

    @JsonIgnore
    public boolean isUnavailableForProcessing() {
        return this.notBefore != null && this.notBefore.isAfter(ZonedDateTime.now(ZoneOffset.UTC));
    }

    public JWT setAudience(Object audience) {
        this.audience = audience;
        return this;
    }

    public JWT setExpiration(ZonedDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    public JWT setIssuedAt(ZonedDateTime issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    public JWT setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public JWT setNotBefore(ZonedDateTime notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    public JWT setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public JWT setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
        return this;
    }

    public String toString() {
        return new String(Mapper.prettyPrint(this));
    }

    private Object lookupClaim(String key) {
        switch (key) {
            case "aud": {
                return this.audience;
            }
            case "exp": {
                return this.expiration;
            }
            case "iat": {
                return this.issuedAt;
            }
            case "iss": {
                return this.issuer;
            }
            case "jti": {
                return this.uniqueId;
            }
            case "nbf": {
                return this.notBefore;
            }
            case "sub": {
                return this.subject;
            }
        }
        return this.otherClaims.get(key);
    }

    private ZonedDateTime toZonedDateTime(String claim, Object value) {
        if (value instanceof ZonedDateTime) {
            return (ZonedDateTime)value;
        }
        if (value instanceof Number) {
            return Instant.ofEpochSecond(((Number)value).longValue()).atZone(ZoneOffset.UTC);
        }
        throw new IllegalArgumentException("Invalid numeric value for [" + claim + "] claim");
    }
}

