/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.der;

import io.fusionauth.der.DerInputStream;
import io.fusionauth.der.DerOutputStream;
import io.fusionauth.der.ObjectIdentifier;
import io.fusionauth.der.Tag;
import io.fusionauth.der.TagClass;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;

public class DerValue {
    public Tag tag;
    private DerInputStream value;

    public DerValue(Tag tag, byte[] value) {
        this.tag = tag;
        this.value = new DerInputStream(value);
    }

    public DerValue(int tag, byte[] value) {
        this.tag = new Tag(tag);
        this.value = new DerInputStream(value);
    }

    public DerValue(BigInteger integer) {
        this.tag = new Tag(2);
        this.value = new DerInputStream(integer.toByteArray());
    }

    public DerValue(int tag, DerOutputStream os) {
        this.tag = new Tag(tag);
        this.value = new DerInputStream(os.toByteArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DerValue)) {
            return false;
        }
        DerValue derValue = (DerValue)o;
        return this.tag == derValue.tag && Arrays.equals(this.value.toByteArray(), derValue.value.toByteArray());
    }

    public BigInteger getBigInteger(boolean signed) {
        return signed ? new BigInteger(this.value.toByteArray()) : new BigInteger(1, this.value.toByteArray());
    }

    public BigInteger getBigInteger() {
        return this.getBigInteger(true);
    }

    public String getBitString() {
        if (this.tag.value != 3) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        byte[] bytes = this.value.toByteArray();
        byte ignoreByte = bytes[0];
        for (int i = 1; i < bytes.length; ++i) {
            if (i == bytes.length - 1 && ignoreByte != 0) {
                int b = (bytes[i] & 0xFF) >> ignoreByte;
                sb.append(String.format("%" + (8 - ignoreByte) + "s", Integer.toBinaryString(b)).replace(' ', '0'));
                continue;
            }
            sb.append(String.format("%8s", Integer.toBinaryString(bytes[i] & 0xFF)).replace(' ', '0'));
        }
        return sb.toString();
    }

    public int getLength() {
        return this.value.length;
    }

    public ObjectIdentifier getOID() throws IOException {
        return this.value.getOID();
    }

    public BigInteger getPositiveBigInteger() {
        return this.getBigInteger(false);
    }

    public int hashCode() {
        int result = Objects.hash(this.tag);
        result = 31 * result + Arrays.hashCode(this.value.toByteArray());
        return result;
    }

    public byte[] toByteArray() {
        return this.value.toByteArray();
    }

    public String toString() {
        if (this.tag.tagClass == TagClass.ContextSpecific) {
            return this.tag.toString();
        }
        return this.tag.getName() + ", length=" + this.value.length;
    }
}

