/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.pem.domain;

import io.fusionauth.jwt.domain.Buildable;
import io.fusionauth.pem.PEMDecoder;
import io.fusionauth.pem.PEMEncoder;
import java.nio.file.Path;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Objects;

public class PEM
implements Buildable<PEM> {
    public static final String EC_PRIVATE_KEY_PREFIX = "-----BEGIN EC PRIVATE KEY-----";
    public static final String EC_PRIVATE_KEY_SUFFIX = "-----END EC PRIVATE KEY-----";
    public static final String PKCS_1_PRIVATE_KEY_PREFIX = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String PKCS_1_PRIVATE_KEY_SUFFIX = "-----END RSA PRIVATE KEY-----";
    public static final String PKCS_1_PUBLIC_KEY_PREFIX = "-----BEGIN RSA PUBLIC KEY-----";
    public static final String PKCS_1_PUBLIC_KEY_SUFFIX = "-----END RSA PUBLIC KEY-----";
    public static final String PKCS_8_PRIVATE_KEY_PREFIX = "-----BEGIN PRIVATE KEY-----";
    public static final String PKCS_8_PRIVATE_KEY_SUFFIX = "-----END PRIVATE KEY-----";
    public static final String X509_CERTIFICATE_PREFIX = "-----BEGIN CERTIFICATE-----";
    public static final String X509_CERTIFICATE_SUFFIX = "-----END CERTIFICATE-----";
    public static final String X509_PUBLIC_KEY_PREFIX = "-----BEGIN PUBLIC KEY-----";
    public static final String X509_PUBLIC_KEY_SUFFIX = "-----END PUBLIC KEY-----";
    public Certificate certificate;
    public PrivateKey privateKey;
    public PublicKey publicKey;

    public PEM(PrivateKey privateKey, PublicKey publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public PEM(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PEM(Certificate certificate) {
        this.certificate = certificate;
        this.publicKey = certificate.getPublicKey();
    }

    public PEM(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public static PEM decode(Path path) {
        return new PEMDecoder().decode(path);
    }

    public static PEM decode(String encodedPEM) {
        return new PEMDecoder().decode(encodedPEM);
    }

    public static PEM decode(byte[] bytes) {
        return new PEMDecoder().decode(bytes);
    }

    public static String encode(Key key) {
        return new PEMEncoder().encode(key);
    }

    public static String encode(PrivateKey privateKey, PublicKey publicKey) {
        return new PEMEncoder().encode(privateKey, publicKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PEM)) {
            return false;
        }
        PEM pem = (PEM)o;
        return Objects.equals(this.certificate, pem.certificate) && Objects.equals(this.privateKey, pem.privateKey) && Objects.equals(this.publicKey, pem.publicKey);
    }

    public <T> T getPrivateKey() {
        return (T)this.privateKey;
    }

    public <T> T getPublicKey() {
        return (T)this.publicKey;
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.privateKey, this.publicKey);
    }
}

