/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.rsa;

import io.fusionauth.jwt.InvalidJWTSignatureException;
import io.fusionauth.jwt.InvalidKeyLengthException;
import io.fusionauth.jwt.JWTVerifierException;
import io.fusionauth.jwt.MissingPublicKeyException;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.pem.domain.PEM;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;

public class RSAVerifier
implements Verifier {
    private final RSAPublicKey publicKey;

    private RSAVerifier(String publicKey) {
        PEM pem = PEM.decode(publicKey);
        if (pem.publicKey == null) {
            throw new MissingPublicKeyException("The provided PEM encoded string did not contain a public key.");
        }
        this.publicKey = (RSAPublicKey)pem.getPublicKey();
        int keyLength = this.publicKey.getModulus().bitLength();
        if (keyLength < 2048) {
            throw new InvalidKeyLengthException("Key length of [" + keyLength + "] is less than the required key length of 2048 bits.");
        }
    }

    public static RSAVerifier newVerifier(String publicKey) {
        Objects.requireNonNull(publicKey);
        return new RSAVerifier(publicKey);
    }

    public static RSAVerifier newVerifier(Path path) {
        Objects.requireNonNull(path);
        try {
            return new RSAVerifier(new String(Files.readAllBytes(path)));
        }
        catch (IOException e) {
            throw new JWTVerifierException("Unable to read the file from path [" + path.toAbsolutePath().toString() + "]", e);
        }
    }

    public static RSAVerifier newVerifier(byte[] bytes) {
        Objects.requireNonNull(bytes);
        return new RSAVerifier(new String(bytes));
    }

    @Override
    public boolean canVerify(Algorithm algorithm) {
        switch (algorithm) {
            case RS256: 
            case RS384: 
            case RS512: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void verify(Algorithm algorithm, byte[] message, byte[] signature) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(message);
        Objects.requireNonNull(signature);
        try {
            Signature verifier = Signature.getInstance(algorithm.getName());
            verifier.initVerify(this.publicKey);
            verifier.update(message);
            if (!verifier.verify(signature)) {
                throw new InvalidJWTSignatureException();
            }
        }
        catch (SecurityException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTVerifierException("An unexpected exception occurred when attempting to verify the JWT", e);
        }
    }
}

