/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.ec;

import io.fusionauth.der.DerInputStream;
import io.fusionauth.der.DerOutputStream;
import io.fusionauth.der.DerValue;
import io.fusionauth.jwt.domain.Algorithm;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class ECDSASignature {
    private byte[] bytes;

    public ECDSASignature(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] derDecode(Algorithm algorithm) throws IOException {
        byte[] result;
        DerValue[] sequence = new DerInputStream(this.bytes).getSequence();
        byte[] r = sequence[0].getPositiveBigInteger().toByteArray();
        byte[] s = sequence[1].getPositiveBigInteger().toByteArray();
        switch (algorithm) {
            case ES256: {
                result = new byte[64];
                break;
            }
            case ES384: {
                result = new byte[96];
                break;
            }
            case ES512: {
                result = new byte[132];
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to decode the signature for algorithm [" + algorithm.name() + "]");
            }
        }
        int len = result.length / 2;
        System.arraycopy(r, r.length > len ? 1 : 0, result, r.length < len ? 1 : 0, r.length > len ? len : r.length);
        System.arraycopy(s, s.length > len ? 1 : 0, result, s.length < len ? len + 1 : len, s.length > len ? len : s.length);
        return result;
    }

    public byte[] derEncode() throws IOException {
        byte[] r = Arrays.copyOfRange(this.bytes, 0, this.bytes.length / 2);
        byte[] s = Arrays.copyOfRange(this.bytes, this.bytes.length / 2, this.bytes.length);
        return new DerOutputStream().writeValue(new DerValue(48, new DerOutputStream().writeValue(new DerValue(new BigInteger(1, r))).writeValue(new DerValue(new BigInteger(1, s))))).toByteArray();
    }
}

