/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.rsa;

import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.domain.InvalidJWTSignatureException;
import io.fusionauth.jwt.domain.InvalidKeyLengthException;
import io.fusionauth.jwt.rsa.RSAUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;

public class RSAVerifier
implements Verifier {
    private final RSAPublicKey publicKey;

    private RSAVerifier(String publicKey) {
        Objects.requireNonNull(publicKey);
        this.publicKey = RSAUtils.getPublicKeyFromPEM(publicKey);
        int keyLength = this.publicKey.getModulus().bitLength();
        if (keyLength < 2048) {
            throw new InvalidKeyLengthException("Key length of [" + keyLength + "] is less than the required key length of 2048 bits.");
        }
    }

    public static RSAVerifier newVerifier(String publicKey) {
        return new RSAVerifier(publicKey);
    }

    @Override
    public boolean canVerify(Algorithm algorithm) {
        switch (algorithm) {
            case RS256: 
            case RS384: 
            case RS512: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void verify(Algorithm algorithm, byte[] payload, byte[] signature) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(payload);
        Objects.requireNonNull(signature);
        try {
            Signature verifier = Signature.getInstance(algorithm.getName());
            verifier.initVerify(this.publicKey);
            verifier.update(payload);
            if (!verifier.verify(signature)) {
                throw new InvalidJWTSignatureException();
            }
        }
        catch (SecurityException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }
}

