/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.hmac;

import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.domain.InvalidJWTSignatureException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACVerifier
implements Verifier {
    private final byte[] secret;

    private HMACVerifier(String secret) {
        Objects.requireNonNull(secret);
        this.secret = secret.getBytes(StandardCharsets.UTF_8);
    }

    public static HMACVerifier newVerifier(String secret) {
        return new HMACVerifier(secret);
    }

    @Override
    public boolean canVerify(Algorithm algorithm) {
        switch (algorithm) {
            case HS256: 
            case HS384: 
            case HS512: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void verify(Algorithm algorithm, byte[] payload, byte[] signature) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(payload);
        Objects.requireNonNull(signature);
        try {
            Mac mac = Mac.getInstance(algorithm.getName());
            mac.init(new SecretKeySpec(this.secret, algorithm.getName()));
            byte[] actualSignature = mac.doFinal(payload);
            if (!Arrays.equals(signature, actualSignature)) {
                throw new InvalidJWTSignatureException();
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

