/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.rsa;

import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.domain.InvalidKeyLengthException;
import io.fusionauth.jwt.rsa.RSAUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.util.Objects;

public class RSASigner
implements Signer {
    private final Algorithm algorithm;
    private RSAPrivateKey privateKey;

    private RSASigner(Algorithm algorithm, String privateKey) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(privateKey);
        this.algorithm = algorithm;
        this.privateKey = RSAUtils.getPrivateKeyFromPEM(privateKey);
        int keyLength = this.privateKey.getModulus().bitLength();
        if (keyLength < 2048) {
            throw new InvalidKeyLengthException("Key length of [" + keyLength + "] is less than the required key length of 2048 bits.");
        }
    }

    public static RSASigner newSHA256Signer(String privateKey) {
        return new RSASigner(Algorithm.RS256, privateKey);
    }

    public static RSASigner newSHA384Signer(String privateKey) {
        return new RSASigner(Algorithm.RS384, privateKey);
    }

    public static RSASigner newSHA512Signer(String privateKey) {
        return new RSASigner(Algorithm.RS512, privateKey);
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] sign(String message) {
        try {
            Signature signature = Signature.getInstance(this.algorithm.getName());
            signature.initSign(this.privateKey);
            signature.update(message.getBytes(StandardCharsets.UTF_8));
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }
}

