/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt;

import io.fusionauth.jwt.domain.Algorithm;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

public class OpenIDConnect {
    public static String at_hash(String accessToken, Algorithm algorithm) throws NoSuchAlgorithmException {
        return OpenIDConnect.generate_hash(accessToken, algorithm, 128);
    }

    public static String c_hash(String authorizationCode, Algorithm algorithm) throws NoSuchAlgorithmException {
        return OpenIDConnect.generate_hash(authorizationCode, algorithm, 256);
    }

    private static String generate_hash(String string, Algorithm algorithm, int leftMostBits) throws NoSuchAlgorithmException {
        MessageDigest messageDigest;
        Objects.requireNonNull(string);
        Objects.requireNonNull(algorithm);
        if (leftMostBits % 8 != 0) {
            throw new IllegalArgumentException("The leftMostBits parameter is not valid. It must be a factor of 8.");
        }
        if (algorithm == Algorithm.RS256) {
            messageDigest = MessageDigest.getInstance("SHA-256");
        } else if (algorithm == Algorithm.RS384) {
            messageDigest = MessageDigest.getInstance("SHA-384");
        } else if (algorithm == Algorithm.RS512) {
            messageDigest = MessageDigest.getInstance("SHA-512");
        } else {
            throw new IllegalArgumentException("You specified an unsupported algorithm. The algorithm [" + (Object)((Object)algorithm) + "] is not supported. You must use RS256, RS384 or RS512.");
        }
        byte[] digest = string.getBytes(Charset.forName("UTF-8"));
        digest = messageDigest.digest(digest);
        int toIndex = Math.min(digest.length, leftMostBits / 8);
        byte[] leftMostBytes = Arrays.copyOfRange(digest, 0, toIndex);
        return new String(Base64.getUrlEncoder().withoutPadding().encode(leftMostBytes));
    }
}

