/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt;

import io.fusionauth.jwt.domain.RSAKeyPair;
import io.fusionauth.jwt.rsa.RSAUtils;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;

public class JWTUtils {
    public static RSAKeyPair generate2048RSAKeyPair() {
        return JWTUtils.generateRSAKeyPair(2048);
    }

    public static RSAKeyPair generate3072RSAKeyPair() {
        return JWTUtils.generateRSAKeyPair(3072);
    }

    public static RSAKeyPair generate4096RSAKeyPair() {
        return JWTUtils.generateRSAKeyPair(4096);
    }

    public static String generateSHA256HMACSecret() {
        byte[] buffer = new byte[32];
        new SecureRandom().nextBytes(buffer);
        return Base64.getEncoder().encodeToString(buffer);
    }

    public static String generateSHA384HMACSecret() {
        byte[] buffer = new byte[48];
        new SecureRandom().nextBytes(buffer);
        return Base64.getEncoder().encodeToString(buffer);
    }

    public static String generateSHA512HMACSecret() {
        byte[] buffer = new byte[64];
        new SecureRandom().nextBytes(buffer);
        return Base64.getEncoder().encodeToString(buffer);
    }

    private static RSAKeyPair generateRSAKeyPair(int keySize) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(keySize);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            String privateKey = RSAUtils.getPEMFromPrivateKey(keyPair.getPrivate());
            String publicKey = RSAUtils.getPEMFromPublicKey(keyPair.getPublic());
            return new RSAKeyPair(privateKey, publicKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

