/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra;

import io.fair_acc.math.MathBase;
import io.fair_acc.math.spectra.Convolution;
import io.fair_acc.math.utils.ConcurrencyUtils;

public class HilbertTransform
extends Convolution {
    public double[] computeAmplitude(double[] data) {
        int nsamples = data.length;
        double[] hdata = this.transformFourier(data);
        double[] amplitude = new double[nsamples];
        for (int i = 0; i < nsamples; ++i) {
            double a = hdata[i];
            double b = data[i];
            amplitude[i] = Math.sqrt(MathBase.sqr(a) + MathBase.sqr(b));
        }
        return amplitude;
    }

    public double[] computeInstantaneousAmplitude(double[] data) {
        int nsamples = data.length;
        double[] amplitude = this.computeAmplitude(data);
        double[] lowPass = Convolution.getLowPassFilter(ConcurrencyUtils.nextPow2(3 * nsamples), 0.4);
        Convolution.complexMultiply(lowPass, lowPass);
        return this.transform(amplitude, lowPass, false);
    }

    public double[] computeInstantaneousFrequency(double[] data) {
        int nsamples = data.length;
        double[] phase = this.computePhase(data);
        double[] filter = Convolution.getDerivativeFilter(ConcurrencyUtils.nextPow2(3 * nsamples));
        double[] frequency = this.transform(phase, filter, false);
        for (int i = 1; i < frequency.length - 1; ++i) {
            int n = i;
            frequency[n] = frequency[n] / (Math.PI * 2);
            if (frequency[i] > 0.5) {
                frequency[i] = 1.0 - frequency[i];
                continue;
            }
            if (!(frequency[i] > 0.5)) continue;
            frequency[i] = 0.0;
        }
        frequency[0] = 0.0;
        frequency[frequency.length - 1] = 0.0;
        double[] lowPass = Convolution.getLowPassFilter(ConcurrencyUtils.nextPow2(3 * nsamples), 0.4);
        Convolution.complexMultiply(lowPass, lowPass);
        return this.transform(frequency, lowPass, false);
    }

    public double[] computePhase(double[] data) {
        int nsamples = data.length;
        double[] hdata = this.transformFourier(data);
        double[] phase = new double[nsamples];
        for (int i = 0; i < nsamples; ++i) {
            double phas;
            double a = hdata[i];
            double b = data[i];
            phase[i] = phas = Math.atan2(a, b);
        }
        HilbertTransform.UnwrapPhase2(phase);
        return phase;
    }

    public double[] computePhase(double[] data, double[] amplitude) {
        int nsamples = data.length;
        double[] hdata = this.transformTime(data);
        double[] phase = new double[nsamples];
        for (int i = 0; i < nsamples; ++i) {
            double a = hdata[i];
            double b = data[i];
            double phas = Math.atan2(a, b);
            double ampl = Math.sqrt(a * a + b * b);
            phase[i] = phas;
            amplitude[i] = (float)ampl;
        }
        HilbertTransform.UnwrapPhase2(phase);
        return phase;
    }

    public double[] transform(double[] data) {
        return this.transformFourier(data);
    }

    public double[] transform2(double[] data) {
        double[] htransformed = new double[data.length];
        boolean n_hilbert = true;
        double[] h = new double[3];
        h[1] = 0.0;
        for (int i = 1; i <= 1; ++i) {
            double window = 0.54 + 0.46 * Math.cos(Math.PI * (double)i / 1.0);
            h[1 + i] = window * (-((double)(i % 2)) * 2.0 / (Math.PI * (double)i));
            h[1 - i] = -h[1 + i];
        }
        for (int k = 0; k < data.length; ++k) {
            double sum = 0.0;
            for (int j = 0; j < h.length; ++j) {
                int u = j + 1;
                if (k >= u) {
                    sum += h[j] * data[k - u];
                    continue;
                }
                sum += h[j] * data[0];
            }
            if (k - h.length < 0 || k - h.length > htransformed.length) continue;
            htransformed[k - h.length] = sum;
        }
        return htransformed;
    }

    public double[] transformFourier(double[] data) {
        int nsamples = data.length;
        int fft_samples = ConcurrencyUtils.nextPow2(3 * nsamples);
        double[] filter = Convolution.getHilbertFilter(fft_samples);
        return this.transform(data, filter, false);
    }

    public double[] transformTime(double[] data) {
        int nsamples = data.length;
        int half = nsamples / 2;
        double[] htransformed = new double[nsamples];
        double norm = 0.6366197723675814;
        for (int k = 0; k < nsamples; ++k) {
            double sum = 0.0;
            if (k % 2 == 0) {
                for (j = 0; j < half; ++j) {
                    j2 = (j << 1) + 1;
                    sum += data[j2] / (double)(k - j2);
                }
            } else {
                for (j = 0; j < half; ++j) {
                    j2 = j << 1;
                    sum += data[j2] / (double)(k - j2);
                }
            }
            htransformed[k] = sum * 0.6366197723675814;
        }
        return htransformed;
    }

    public static double modulo(double x, double m) {
        while (x < 0.0) {
            x += m;
        }
        while (x >= m) {
            x -= m;
        }
        return x;
    }

    public static void UnwrapPhase1(double[] phase) {
        double window = 0.0;
        for (int i = 0; i < phase.length - 1; ++i) {
            double p1 = HilbertTransform.modulo(phase[i], Math.PI * 2);
            double p2 = HilbertTransform.modulo(phase[i + 1], Math.PI * 2);
            double pstep = p2 - p1;
            double c = 0.0;
            c = pstep > Math.PI ? -1.0 : (pstep <= -Math.PI ? 1.0 : 0.0);
            phase[i + 1] = (window += c * (Math.PI * 2)) + p2;
        }
    }

    public static void UnwrapPhase2(double[] phase) {
        double phase0 = phase[0];
        for (int i = 1; i < phase.length; ++i) {
            double diff = HilbertTransform.modulo(phase[i] - phase[i - 1], Math.PI * 2);
            phase[i] = phase0 += diff;
        }
    }
}

