/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.DataSetBuilder;
import io.fair_acc.math.Math;
import io.fair_acc.math.MathBase;
import io.fair_acc.math.Spline;
import io.fair_acc.math.TRandom;
import io.fair_acc.math.matrix.MatrixD;
import io.fair_acc.math.spectra.Convolution;
import io.fair_acc.math.spectra.HilbertTransform;
import io.fair_acc.math.spectra.SpectrumTools;
import io.fair_acc.math.utils.ConcurrencyUtils;

public class EEMD {
    private static final TRandom rnd = new TRandom(0L);
    private int fstatus = 100;

    public MatrixD eemd(double[] data, double rms_noise, double NE) {
        int xsize = data.length;
        double[] X1 = new double[xsize];
        double[] xorigin = new double[xsize];
        double[] xstart = new double[xsize];
        double[] xstart_old = new double[xsize];
        double[] xend = new double[xsize];
        double Ystd = Math.rms(data);
        int TNM = (int)Math.floor(MathBase.log2(xsize)) - 1;
        int TNM2 = TNM + 2;
        MatrixD allmode = new MatrixD(xsize, TNM2 + 1);
        MatrixD mode = new MatrixD(xsize, TNM2 + 1);
        int iii = 0;
        while ((double)iii < NE) {
            int jj;
            for (int i = 0; i < xsize; ++i) {
                double temp = TRandom.Gaus(0.0, rms_noise);
                X1[i] = data[i] / Ystd + temp;
            }
            for (jj = 0; jj < xsize; ++jj) {
                mode.set(jj, 0, data[jj]);
            }
            System.arraycopy(X1, 0, xorigin, 0, xsize);
            System.arraycopy(X1, 0, xend, 0, xsize);
            for (int nmode = 1; nmode < TNM; ++nmode) {
                System.arraycopy(xend, 0, xstart, 0, xsize);
                System.arraycopy(xend, 0, xstart_old, 0, xsize);
                this.fstatus = (int)((double)nmode / (double)TNM) * 100;
                boolean abort = false;
                for (int iter = 0; iter < 30000; ++iter) {
                    double estimate;
                    double[][] spmax = SpectrumTools.computeMaxima(xstart);
                    double[][] spmin = SpectrumTools.computeMinima(xstart);
                    int nextrema = spmax[0].length + spmin[0].length;
                    int ncrossing = EEMD.computeZeroCrossings(xstart);
                    if (spmax[0].length < 3 || spmin[0].length < 3) {
                        abort = true;
                        System.err.println("break loop: iter = " + iter + " nmode " + nmode);
                        break;
                    }
                    Spline upper = new Spline(spmax[0], spmax[1]);
                    Spline lower = new Spline(spmin[0], spmin[1]);
                    int i = 0;
                    while (i < xsize) {
                        double mean_ul = (upper.getValue(i) + lower.getValue(i)) / 2.0;
                        int n = i++;
                        xstart[n] = xstart[n] - mean_ul;
                    }
                    double sum_sqr = 0.0;
                    double diff_sqr = 0.0;
                    for (int i2 = 0; i2 < xstart.length; ++i2) {
                        diff_sqr += MathBase.sqr(xstart_old[i2] - xstart[i2]);
                        sum_sqr += MathBase.sqr(xstart_old[i2]);
                    }
                    double break_crit = 1.0E-12;
                    double d = estimate = sum_sqr != 0.0 ? diff_sqr / sum_sqr : 42.0;
                    if (sum_sqr == 0.0 || estimate < 1.0E-12) {
                        System.err.printf("break at mode %d and  iteration %d with criteria %e\n", nmode, iter, estimate);
                        break;
                    }
                    if (sum_sqr == 0.0 || Math.abs(nextrema - ncrossing) <= 0) {
                        System.err.printf("break (crossing) at mode %d and  iteration %d with criteria %f\n", nmode, iter, diff_sqr / sum_sqr);
                        break;
                    }
                    System.arraycopy(xstart, 0, xstart_old, 0, xstart.length);
                }
                for (int i = 0; i < xsize; ++i) {
                    int n = i;
                    xend[n] = xend[n] - xstart[i];
                }
                for (int jj2 = 0; jj2 < xsize; ++jj2) {
                    mode.set(jj2, nmode, xstart[jj2]);
                }
                if (!abort) continue;
                nmode = TNM + 1;
            }
            for (jj = 0; jj < xsize; ++jj) {
                mode.set(jj, TNM + 1, xend[jj]);
            }
            allmode.plus(mode);
            ++iii;
        }
        allmode.times(1.0 / NE);
        allmode.times(Ystd);
        return mode;
    }

    public synchronized DataSet getScalogram(double[] data, int nQuantx, int nQuanty) {
        int i;
        this.fstatus = 0;
        int nsamples = data.length;
        double[] time = new double[nsamples];
        double[] frequency = new double[nsamples / 2];
        for (i = 0; i < nsamples; ++i) {
            time[i] = i;
        }
        for (i = 0; i < nsamples / 2; ++i) {
            frequency[i] = (double)i / (double)nsamples;
        }
        DataSet ds = new DataSetBuilder("HilbertSpectrum").setValues(0, time).setValues(1, frequency).setValues(2, this.getSpectrumArray(data, nQuantx, nQuanty)).build();
        this.fstatus = 100;
        return ds;
    }

    public double[][] getSpectrumArray(double[] data, int nQuantx, int Quanty) {
        int nsamples = data.length;
        double[][] ret = new double[nsamples / 2][nsamples];
        for (int i = 0; i < nsamples / 2; ++i) {
            for (int j = 0; j < nsamples; ++j) {
                ret[i][j] = Double.NaN;
            }
        }
        HilbertTransform hilbert = new HilbertTransform();
        MatrixD emd = this.eemd(data, 0.0, 1.0);
        double[] mode = new double[nsamples];
        int nmodes = emd.getColumnDimension() - 1;
        for (int nmode = 1; nmode < nmodes; ++nmode) {
            for (int j = 0; j < nsamples; ++j) {
                mode[j] = emd.get(j, nmode);
            }
            Convolution decon = new Convolution();
            double[] lowPass = Convolution.getLowPassFilter(ConcurrencyUtils.nextPow2(3 * nsamples), 0.3);
            double[] amplitude = hilbert.computeInstantaneousAmplitude(mode);
            double[] frequency = hilbert.computeInstantaneousFrequency(mode);
            double[] amplitude_filtered = decon.transform(amplitude, lowPass, false);
            double[] frequency_filtered = decon.transform(frequency, lowPass, false);
            for (int j = 0; j < nsamples; ++j) {
                if (j >= nsamples) continue;
                int yIndex = (int)(frequency_filtered[j] * (double)nsamples);
                if (yIndex < 0) {
                    yIndex = 0;
                } else if (yIndex >= nsamples / 2) {
                    yIndex = nsamples / 2 - 1;
                }
                ret[yIndex][j] = 10.0 * Math.log(amplitude_filtered[j]);
                if (!(ret[yIndex][j] < -10.0) && !(ret[yIndex][j] > 10.0)) continue;
                ret[yIndex][j] = Double.NaN;
            }
        }
        return ret;
    }

    public int getStatus() {
        return this.fstatus;
    }

    public boolean isBusy() {
        return this.fstatus < 100;
    }

    public static int computeZeroCrossings(double[] data) {
        int dsize = data.length;
        int val = 0;
        boolean positive = data[0] >= 0.0;
        for (int i = 1; i < dsize; ++i) {
            if (positive) {
                if (!(data[i] < 0.0)) continue;
                positive = false;
                ++val;
                continue;
            }
            if (!(data[i] > 0.0)) continue;
            positive = true;
            ++val;
        }
        return val;
    }

    public static int extrema(double[] data, double[][] spmax, double[][] spmin) {
        int dsize = data.length;
        int kk = 0;
        int ll = 0;
        if (data[0] >= data[1]) {
            spmax[0][0] = 0.0;
            spmax[1][0] = data[0];
            ++kk;
        } else {
            spmin[0][0] = 0.0;
            spmin[1][0] = data[0];
            ++ll;
        }
        for (int jj = 1; jj < dsize - 1; ++jj) {
            if (data[jj - 1] <= data[jj] && data[jj] >= data[jj + 1]) {
                spmax[0][kk] = jj;
                spmax[1][kk] = data[jj];
                ++kk;
                continue;
            }
            if (!(data[jj - 1] >= data[jj]) || !(data[jj] <= data[jj + 1])) continue;
            spmin[0][ll] = jj;
            spmin[1][ll] = data[jj];
            ++ll;
        }
        if (data[dsize - 2] <= data[dsize - 1]) {
            spmax[0][kk] = (double)dsize - 1.0;
            spmax[1][kk] = data[dsize - 1];
            ++kk;
        } else {
            spmin[0][ll] = (double)dsize - 1.0;
            spmin[1][ll] = data[dsize - 1];
            ++ll;
        }
        return kk + ll > 2 ? 1 : -1;
    }
}

