/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.functions;

import io.fair_acc.math.functions.AbstractFunction1D;
import io.fair_acc.math.functions.Function1D;

public class PolynomialFunction
extends AbstractFunction1D
implements Function1D {
    public PolynomialFunction(String name, double[] parameter) {
        super(name, parameter);
        this.setParameterNames();
        this.setErrorEstimateComputation(true);
    }

    public PolynomialFunction(String name, double[] parameter, String[] parameterNames) {
        super(name, parameter, parameterNames);
        this.setErrorEstimateComputation(true);
    }

    public PolynomialFunction(String name, int order) {
        super(name, order);
        this.setParameterNames();
        this.setErrorEstimateComputation(true);
    }

    @Override
    public double getValue(double x) {
        double val = 0.0;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            val += this.getParameterValue(i) * Math.pow(x, i);
        }
        return val;
    }

    @Override
    public void setParameterCount(int count) {
        super.setParameterCount(count);
        this.setParameterNames();
    }

    private void setParameterNames() {
        for (int i = 0; i < this.getParameterCount(); ++i) {
            this.setParameterName(i, "p" + i);
        }
    }

    public static void main(String[] args) {
        PolynomialFunction func = new PolynomialFunction("poly1", new double[]{0.5, 1.0, 2.0, 0.6});
        for (int i = -3; i <= 3; ++i) {
            double x = i;
            System.out.printf("%+2d: poly(%+4.2f) = %f\n", i, x, func.getValue(x));
        }
        func.printParameters(true);
    }
}

