/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.BandPassTransform;
import io.fair_acc.math.filter.iir.BandStopTransform;
import io.fair_acc.math.filter.iir.Cascade;
import io.fair_acc.math.filter.iir.HighPassTransform;
import io.fair_acc.math.filter.iir.LayoutBase;
import io.fair_acc.math.filter.iir.LowPassTransform;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.util.FastMath;

public class ChebyshevI
extends Cascade {
    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, rippleDb, 0);
    }

    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb, int directFormType) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, rippleDb, directFormType);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, rippleDb, 0);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb, int directFormType) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, rippleDb, directFormType);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency, double rippleDb) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, rippleDb, 0);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency, double rippleDb, int directFormType) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, rippleDb, directFormType);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency, double rippleDb) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, rippleDb, 0);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency, double rippleDb, int directFormType) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, rippleDb, directFormType);
    }

    private void setupBandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb, int directFormType) {
        AnalogLowPass analogProto = new AnalogLowPass(order);
        analogProto.design(rippleDb);
        LayoutBase digitalProto = new LayoutBase(order * 2);
        BandPassTransform.transform(centerFrequency / sampleRate, widthFrequency / sampleRate, digitalProto, analogProto);
        this.setLayout(digitalProto, directFormType);
    }

    private void setupBandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb, int directFormType) {
        AnalogLowPass analogProto = new AnalogLowPass(order);
        analogProto.design(rippleDb);
        LayoutBase digitalProto = new LayoutBase(order * 2);
        BandStopTransform.transform(centerFrequency / sampleRate, widthFrequency / sampleRate, digitalProto, analogProto);
        this.setLayout(digitalProto, directFormType);
    }

    private void setupHighPass(int order, double sampleRate, double cutoffFrequency, double rippleDb, int directFormType) {
        AnalogLowPass analogProto = new AnalogLowPass(order);
        analogProto.design(rippleDb);
        LayoutBase digitalProto = new LayoutBase(order);
        HighPassTransform.transform(cutoffFrequency / sampleRate, digitalProto, analogProto);
        this.setLayout(digitalProto, directFormType);
    }

    private void setupLowPass(int order, double sampleRate, double cutoffFrequency, double rippleDb, int directFormType) {
        AnalogLowPass analogProto = new AnalogLowPass(order);
        analogProto.design(rippleDb);
        LayoutBase digitalProto = new LayoutBase(order);
        LowPassTransform.transform(cutoffFrequency / sampleRate, digitalProto, analogProto);
        this.setLayout(digitalProto, directFormType);
    }

    private static class AnalogLowPass
    extends LayoutBase {
        private final int nPoles;

        public AnalogLowPass(int nPoles) {
            super(nPoles);
            this.nPoles = nPoles;
        }

        public void design(double rippleDb) {
            this.reset();
            double eps = Math.sqrt(1.0 / Math.exp(-rippleDb * 0.1 * Math.log(10.0)) - 1.0);
            double v0 = FastMath.asinh((double)(1.0 / eps)) / (double)this.nPoles;
            double sinhv0 = -Math.sinh(v0);
            double coshv0 = Math.cosh(v0);
            double n2 = 2.0 * (double)this.nPoles;
            int pairs = this.nPoles / 2;
            for (int i = 0; i < pairs; ++i) {
                int k = 2 * i + 1 - this.nPoles;
                double a = sinhv0 * Math.cos((double)k * Math.PI / n2);
                double b = coshv0 * Math.sin((double)k * Math.PI / n2);
                this.addPoleZeroConjugatePairs(new Complex(a, b), new Complex(Double.POSITIVE_INFINITY));
            }
            if ((this.nPoles & 1) == 1) {
                this.add(new Complex(sinhv0, 0.0), new Complex(Double.POSITIVE_INFINITY));
                this.setNormal(0.0, 1.0);
            } else {
                this.setNormal(0.0, Math.pow(10.0, -rippleDb / 20.0));
            }
        }
    }
}

