/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.Biquad;
import io.fair_acc.math.filter.iir.DirectFormAbstract;
import io.fair_acc.math.filter.iir.DirectFormI;
import io.fair_acc.math.filter.iir.DirectFormII;
import io.fair_acc.math.filter.iir.LayoutBase;
import io.fair_acc.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.complex.ComplexUtils;

public class Cascade {
    private Biquad[] mBiquads;
    private DirectFormAbstract[] mStates;
    private int mNumBiquads = 0;

    public void applyScale(double scale) {
        if (this.mBiquads.length > 0) {
            this.mBiquads[0].applyScale(scale);
        }
    }

    public double filter(double in) {
        double out = in;
        for (int i = 0; i < this.mNumBiquads; ++i) {
            if (this.mStates[i] == null) continue;
            out = this.mStates[i].process1(out, this.mBiquads[i]);
        }
        return out;
    }

    public Biquad getBiquad(int index) {
        return this.mBiquads[index];
    }

    public int getNumBiquads() {
        return this.mNumBiquads;
    }

    public void reset() {
        for (int i = 0; i < this.mNumBiquads; ++i) {
            this.mStates[i].reset();
        }
    }

    public Complex response(double normalizedFrequency) {
        double w = Math.PI * 2 * normalizedFrequency;
        Complex czn1 = ComplexUtils.polar2Complex((double)1.0, (double)(-w));
        Complex czn2 = ComplexUtils.polar2Complex((double)1.0, (double)(-2.0 * w));
        Complex ch = new Complex(1.0);
        Complex cbot = new Complex(1.0);
        for (int i = 0; i < this.mNumBiquads; ++i) {
            Biquad stage = this.mBiquads[i];
            Complex ct = new Complex(stage.getB0() / stage.getA0());
            ct = ct.add(czn1.multiply(stage.getB1() / stage.getA0()));
            ct = ct.add(czn2.multiply(stage.getB2() / stage.getA0()));
            Complex cb = new Complex(1.0);
            cb = cb.add(czn1.multiply(stage.getA1() / stage.getA0()));
            cb = cb.add(czn2.multiply(stage.getA2() / stage.getA0()));
            ch = ch.multiply(ct);
            cbot = cbot.multiply(cb);
        }
        return ch.divide(cbot);
    }

    public void setLayout(LayoutBase proto, int filterTypes) {
        int i;
        int numPoles = proto.getNumPoles();
        this.mNumBiquads = (numPoles + 1) / 2;
        this.mBiquads = new Biquad[this.mNumBiquads];
        switch (filterTypes) {
            case 0: {
                this.mStates = new DirectFormI[this.mNumBiquads];
                for (i = 0; i < this.mNumBiquads; ++i) {
                    this.mStates[i] = new DirectFormI();
                }
                break;
            }
            default: {
                this.mStates = new DirectFormII[this.mNumBiquads];
                for (i = 0; i < this.mNumBiquads; ++i) {
                    this.mStates[i] = new DirectFormII();
                }
            }
        }
        for (i = 0; i < this.mNumBiquads; ++i) {
            PoleZeroPair p = proto.getPair(i);
            this.mBiquads[i] = new Biquad();
            this.mBiquads[i].setPoleZeroPair(p);
        }
        this.applyScale(proto.getNormalGain() / this.response(proto.getNormalW() / (Math.PI * 2)).abs());
    }
}

