/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.events.EventProcessor;
import io.fair_acc.dataset.events.StateListener;
import io.fair_acc.dataset.events.ThreadEventProcessor;
import io.fair_acc.dataset.spi.DoubleErrorDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MathDataSet
extends DoubleErrorDataSet {
    private static final long serialVersionUID = -4978160822533565009L;
    private static final long DEFAULT_UPDATE_LIMIT = 40L;
    private final transient List<DataSet> sourceDataSets;
    private final transient DataSetFunction dataSetFunction;
    private final transient DataSetsFunction dataSetsFunction;
    private final transient DataSetValueFunction dataSetValueFunction;
    private final transient long minUpdatePeriod;
    private final transient String transformName;
    private final BitState inputDataSetBitState = BitState.initDirtyMultiThreaded((Object)((Object)this), (int)ChartBits.DataSetMask);

    public MathDataSet(String transformName, DataSetFunction dataSetFunction, DataSet source) {
        this(transformName, dataSetFunction, null, null, 40L, source);
    }

    public MathDataSet(String transformName, DataSetFunction dataSetFunction, long minUpdatePeriod, DataSet source) {
        this(transformName, dataSetFunction, null, null, minUpdatePeriod, source);
    }

    public MathDataSet(String transformName, DataSetsFunction dataSetFunction, DataSet ... sources) {
        this(transformName, null, dataSetFunction, null, 40L, sources);
    }

    public MathDataSet(String transformName, DataSetsFunction dataSetFunction, long minUpdatePeriod, DataSet ... sources) {
        this(transformName, null, dataSetFunction, null, minUpdatePeriod, sources);
    }

    public MathDataSet(String transformName, DataSetValueFunction dataSetFunction, DataSet source) {
        this(transformName, null, null, dataSetFunction, 40L, source);
    }

    public MathDataSet(String transformName, DataSetValueFunction dataSetFunction, long minUpdatePeriod, DataSet source) {
        this(transformName, null, null, dataSetFunction, minUpdatePeriod, source);
    }

    protected MathDataSet(String transformName, DataSetFunction dataSetFunction, DataSetsFunction dataSetsFunction, DataSetValueFunction dataSetValueFunction, long minUpdatePeriod, DataSet ... sources) {
        super(MathDataSet.getCompositeDataSetName(transformName, sources));
        this.sourceDataSets = new ArrayList<DataSet>(Arrays.asList(sources));
        this.minUpdatePeriod = minUpdatePeriod;
        this.dataSetFunction = dataSetFunction;
        this.dataSetsFunction = dataSetsFunction;
        this.dataSetValueFunction = dataSetValueFunction;
        this.transformName = transformName;
        if (dataSetFunction == null && dataSetsFunction == null && dataSetValueFunction == null) {
            throw new IllegalArgumentException("dataSetFunction, dataSetsFunction and dataSetValueFunction cannot all be null");
        }
        if (dataSetValueFunction != null && this.sourceDataSets.size() > 1) {
            throw new IllegalArgumentException("sources list may not be larger than one if the 'dataSetValueFunction' interface is used -> try to use 'DataSetFunction' instead");
        }
        this.registerListener();
        EventProcessor eventProcessor = ThreadEventProcessor.getUserInstance();
        eventProcessor.addAction(this.inputDataSetBitState, this::update);
    }

    public final void triggerUpdate() {
        this.inputDataSetBitState.setDirty(-1);
    }

    public final void deregisterListener() {
        this.sourceDataSets.forEach(srcDataSet -> srcDataSet.getBitState().removeInvalidateListener((StateListener)this.inputDataSetBitState));
    }

    public final List<DataSet> getSourceDataSets() {
        return this.sourceDataSets;
    }

    public final void registerListener() {
        this.sourceDataSets.forEach(srcDataSet -> srcDataSet.getBitState().addInvalidateListener((StateListener)this.inputDataSetBitState));
    }

    private void handleDataSetValueFunctionInterface() {
        double[] ySourceErrorNeg;
        double[] ySourceErrorPos;
        DataSet dataSet = this.sourceDataSets.get(0);
        int length = dataSet.getDataCount();
        double[] xSourceVector = dataSet.getValues(0);
        double[] ySourceVector = dataSet.getValues(1);
        if (dataSet instanceof DataSetError) {
            DataSetError dsError = (DataSetError)dataSet;
            ySourceErrorPos = dsError.getErrorsPositive(1);
            ySourceErrorNeg = dsError.getErrorsNegative(1);
        } else {
            ySourceErrorNeg = ySourceErrorPos = new double[length];
        }
        if (this.getCapacity() < length) {
            int amount = length - this.getCapacity();
            this.increaseCapacity(amount);
        }
        double[] xDestVector = this.getValues(0);
        double[] yDestVector = this.getValues(1);
        System.arraycopy(xSourceVector, 0, xDestVector, 0, length);
        this.dataSetValueFunction.transform(ySourceVector, yDestVector, length);
        this.set(xDestVector, yDestVector, ySourceErrorNeg, ySourceErrorPos, length, false);
    }

    protected void update() {
        this.lock().writeLockGuard(() -> {
            if (this.dataSetFunction != null) {
                this.set(this.dataSetFunction.transform(this.sourceDataSets.get(0)));
            } else if (this.dataSetsFunction != null) {
                this.dataSetsFunction.transform(this.sourceDataSets, this);
            } else {
                if (this.sourceDataSets.isEmpty()) {
                    return;
                }
                this.handleDataSetValueFunctionInterface();
            }
            this.setName(MathDataSet.getCompositeDataSetName(this.transformName, this.sourceDataSets.toArray(new DataSet[0])));
        });
    }

    protected static String getCompositeDataSetName(String transformName, DataSet ... sources) {
        List<DataSet> dataSets = Arrays.asList(sources);
        String sanitizedFunctionName = transformName == null ? "" : transformName;
        return dataSets.stream().map(DataSet::getName).collect(Collectors.joining(",", sanitizedFunctionName + "(", ")"));
    }

    public static interface DataSetFunction {
        public DataSet transform(DataSet var1);
    }

    public static interface DataSetsFunction {
        public void transform(List<DataSet> var1, MathDataSet var2);
    }

    public static interface DataSetValueFunction {
        public void transform(double[] var1, double[] var2, int var3);
    }
}

