/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.utils;

import io.fabric8.utils.Objects;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperMasterCache {
    private static final transient Logger LOG = LoggerFactory.getLogger(ZooKeeperMasterCache.class);
    private final CuratorFramework curator;
    private final Map<String, String> cache = new ConcurrentHashMap<String, String>();

    public ZooKeeperMasterCache(CuratorFramework curator) {
        this.curator = curator;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public String getStringData(String zkPath) throws Exception {
        String answer = this.cache.get(zkPath);
        if (answer == null) {
            ZooKeeperUtils.getStringData(this.curator, zkPath);
        }
        return answer;
    }

    public void setStringData(String zkPath, String data, CreateMode createMode) throws Exception {
        String currentValue = this.cache.get(data);
        if (currentValue == null || !Objects.equal((Object)currentValue, (Object)data)) {
            ZooKeeperUtils.setData(this.curator, zkPath, data, createMode);
            this.cache.put(zkPath, data);
        }
    }

    public void deleteData(String path) throws Exception {
        if (ZooKeeperUtils.exists(this.curator, path) != null) {
            LOG.info("unregistered web app at " + path);
            ZooKeeperUtils.deleteSafe(this.curator, path);
        }
        this.cache.remove(path);
    }
}

