/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.zookeeper.curator;

import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.zookeeper.bootstrap.ZooKeeperServerFactory;
import io.fabric8.zookeeper.curator.CuratorConfig;
import io.fabric8.zookeeper.curator.ManagedCuratorFramework;
import java.io.IOException;
import java.util.ArrayList;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class CuratorFactoryProducer {
    private ZooKeeperServerFactory serverFactory;

    @Produces
    @Singleton
    public CuratorFramework createCuratorFramework(CuratorConfig curatorConfig, ACLProvider aclProvider, QuorumPeerConfig peerConfig, @ConfigProperty(name="ZOOKEEPER_SERVER_ID", defaultValue="singleRootZkNode") String serverId) throws IOException, InterruptedException {
        String zookeeperUrl = curatorConfig.getZookeeperUrl();
        System.out.println("ZK URL: " + zookeeperUrl);
        System.out.println("ZK config: " + curatorConfig);
        if (Strings.isNullOrBlank((String)zookeeperUrl)) {
            System.out.println("No ZooKeeper URL has been configured so creating a local ensemble server");
            this.serverFactory = new ZooKeeperServerFactory(peerConfig, "rootEnsembleNode");
            zookeeperUrl = this.serverFactory.getZooKeeperUrl();
            Objects.notNull((Object)zookeeperUrl, (String)"zookeeperUrl");
            System.out.println("======= connecting to: " + zookeeperUrl);
            curatorConfig.setZookeeperUrl(zookeeperUrl);
        }
        ArrayList<ConnectionStateListener> connectionListenerList = new ArrayList<ConnectionStateListener>();
        CuratorFramework curatorFramework = ManagedCuratorFramework.createCuratorFramework(curatorConfig, aclProvider, connectionListenerList);
        curatorFramework.start();
        return curatorFramework;
    }
}

