/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.dozer.file;

import io.fabric8.dozer.file.WatcherDozerTypeConverterLoader;
import io.fabric8.watcher.Processor;
import io.fabric8.watcher.file.FileWatcher;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Service;
import org.apache.camel.util.ServiceHelper;
import org.dozer.DozerBeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcherMapping
extends FileWatcher {
    private static final transient Logger LOG = LoggerFactory.getLogger(FileWatcherMapping.class);
    private ConcurrentHashMap<String, WatcherDozerTypeConverterLoader> loaders = new ConcurrentHashMap();
    private CamelContext camelContext;
    private DozerBeanMapper mapper;

    public void init() throws IOException {
        if (this.camelContext == null) {
            throw new IllegalArgumentException("CamelContext must be configured on " + (Object)((Object)this));
        }
        this.mapper = new DozerBeanMapper();
        this.setFileMatchPattern("glob:META-INF/services/dozer/*.xml");
        this.setProcessor(new Processor(){

            public void process(Path path) {
                FileWatcherMapping.this.addOrUpdateMapping(path);
            }

            public void onRemove(Path path) {
                FileWatcherMapping.this.removeMapping(path);
            }
        });
        super.init();
        LOG.info("Watching directory " + this.getRoot() + " for Dozer XML Mapping file changes");
    }

    public void destroy() {
        if (this.mapper != null) {
            this.mapper.destroy();
        }
        super.destroy();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void addOrUpdateMapping(Path path) {
        try {
            String url = FileWatcherMapping.toUrlString(path);
            WatcherDozerTypeConverterLoader loader = this.loaders.get(url);
            if (loader == null) {
                this.addMapping(url);
            } else {
                this.updateMapping(url);
            }
        }
        catch (Exception e) {
            LOG.warn("Ignored path " + path + " due to: " + e, (Throwable)e);
        }
    }

    protected void removeMapping(Path path) {
        try {
            String url = FileWatcherMapping.toUrlString(path);
            LOG.info("Removing Dozer Mapping file " + url);
            WatcherDozerTypeConverterLoader loader = this.loaders.remove(url);
            if (url != null) {
                ServiceHelper.stopAndShutdownService((Object)((Object)loader));
                this.camelContext.removeService((Object)loader);
            }
        }
        catch (Exception e) {
            LOG.warn("Ignored path " + path + " due to: " + e, (Throwable)e);
        }
    }

    private void addMapping(String url) throws Exception {
        LOG.info("Adding Dozer Mapping file " + url);
        WatcherDozerTypeConverterLoader loader = new WatcherDozerTypeConverterLoader(this.camelContext, url, this.mapper);
        this.camelContext.addService((Object)loader);
        this.loaders.put(url, loader);
    }

    private void updateMapping(String url) {
        LOG.info("Updating Dozer Mapping file " + url);
        WatcherDozerTypeConverterLoader loader = this.loaders.get(url);
        if (url != null) {
            try {
                ServiceHelper.stopAndShutdownService((Object)((Object)loader));
                this.camelContext.removeService((Object)loader);
                ServiceHelper.startService((Service)loader);
            }
            catch (Exception e) {
                LOG.warn("Error updating dozer mapping due to: " + e, (Throwable)e);
            }
        }
    }

    protected static String toUrlString(Path path) throws MalformedURLException {
        return path.toUri().toURL().toString();
    }
}

