/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.common.util;

import io.fabric8.common.util.Closeables;
import io.fabric8.common.util.Filter;
import io.fabric8.common.util.Filters;
import io.fabric8.common.util.Function;
import io.fabric8.common.util.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Processes {
    private static final transient Logger LOG = LoggerFactory.getLogger(Processes.class);

    public static boolean isProcessAlive(long pid) {
        List<Long> processIds = Processes.getProcessIds();
        if (processIds.isEmpty()) {
            return true;
        }
        return processIds.contains(pid);
    }

    public static List<Long> getProcessIds() {
        String commands;
        String message = commands = "ps -e";
        LOG.debug("Executing commands: " + message);
        ArrayList<Long> answer = new ArrayList<Long>();
        try {
            Process process = Runtime.getRuntime().exec(commands);
            Processes.parseProcesses(process.getInputStream(), answer, message, Filters.trueFilter());
            Processes.processErrors(process.getErrorStream(), message);
        }
        catch (Exception e) {
            LOG.error("Failed to execute process stdin for " + message + ": " + e, (Throwable)e);
        }
        return answer;
    }

    public static List<Long> getJavaProcessIds(String ... classNameFilter) {
        String commands;
        String message = commands = "jps -l";
        LOG.debug("Executing commands: " + message);
        ArrayList<Long> answer = new ArrayList<Long>();
        Filter<String> filter = Filters.containsAnyString(classNameFilter);
        try {
            Process process = Runtime.getRuntime().exec(commands);
            Processes.parseProcesses(process.getInputStream(), answer, message, filter);
            Processes.processErrors(process.getErrorStream(), message);
        }
        catch (Exception e) {
            LOG.error("Failed to execute process stdin for " + message + ": " + e, (Throwable)e);
        }
        return answer;
    }

    public static int killJavaProcesses() {
        return Processes.killJavaProcesses("karaf", "jboss", "catalina", "spring.Main", "FabricSpringApplication");
    }

    public static int killJavaProcesses(String ... classNameFilters) {
        int count = 0;
        List<Long> javaProcessIds = Processes.getJavaProcessIds(classNameFilters);
        for (Long processId : javaProcessIds) {
            System.out.println("WARNING: Killing Java process " + processId);
            LOG.warn("Killing Java process " + processId);
            Processes.killProcess(processId, "-9");
            ++count;
        }
        return count;
    }

    public static List<String> getDockerContainerIds() {
        String commands = "docker ps -q";
        String message = "output of command: " + commands;
        LOG.debug("Executing commands: " + message);
        final ArrayList<String> answer = new ArrayList<String>();
        try {
            Process process = Runtime.getRuntime().exec(commands);
            Function<String, Void> fn = new Function<String, Void>(){

                @Override
                public Void apply(String line) {
                    if (Strings.isNotBlank(line)) {
                        answer.add(line.trim());
                    }
                    return null;
                }
            };
            Processes.processOutput(process.getInputStream(), fn, message);
            Processes.processErrors(process.getErrorStream(), message);
        }
        catch (Exception e) {
            LOG.error("Failed to execute process stdin for " + message + ": " + e, (Throwable)e);
        }
        return answer;
    }

    public static int killDockerContainer(String containerId) {
        String commands;
        System.out.println("Killing Docker container " + containerId);
        LOG.warn("WARNING: Killing Docker container " + containerId);
        String message = commands = "docker kill " + containerId;
        LOG.debug("Executing commands: " + message);
        ArrayList answer = new ArrayList();
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(commands);
            Processes.processInput(process.getInputStream(), commands);
            Processes.processErrors(process.getErrorStream(), commands);
        }
        catch (Exception e) {
            LOG.error("Failed to execute process stdin for " + message + ": " + e, (Throwable)e);
        }
        return process != null ? process.exitValue() : -1;
    }

    public static void killDockerContainers() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int count = 0;
                List<String> ids = Processes.getDockerContainerIds();
                for (String id : ids) {
                    if (Processes.killDockerContainer(id) != 0) continue;
                    ++count;
                }
            }
        }).run();
    }

    public static int killProcess(Long pid, String params) {
        if (pid == null || !Processes.isProcessAlive(pid)) {
            return 0;
        }
        String commands = "kill " + (params != null ? params + " " : "") + pid;
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        LOG.debug("Executing commands: " + commands);
        try {
            process = runtime.exec(commands);
            Processes.processInput(process.getInputStream(), commands);
            Processes.processErrors(process.getErrorStream(), commands);
        }
        catch (Exception e) {
            LOG.error("Failed to execute process stdin for " + commands + ": " + e, (Throwable)e);
        }
        try {
            return process != null ? process.waitFor() : 1;
        }
        catch (InterruptedException e) {
            String message = String.format("Interrupted while waiting for 'kill %d ' command to finish", pid);
            throw new RuntimeException(message, e);
        }
    }

    protected static void parseProcesses(InputStream inputStream, List<Long> answer, String message, Filter<String> lineFilter) throws Exception {
        block10: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            block7: while (true) {
                try {
                    while (true) {
                        StringTokenizer tokenizer;
                        String line;
                        if ((line = reader.readLine()) == null) {
                            break block10;
                        }
                        if (!lineFilter.matches(line) || !(tokenizer = new StringTokenizer(line)).hasMoreTokens()) continue;
                        String pidText = tokenizer.nextToken();
                        try {
                            long pid = Long.parseLong(pidText);
                            answer.add(pid);
                            continue block7;
                        }
                        catch (NumberFormatException e) {
                            LOG.debug("Could not parse pid " + pidText + " from command: " + message);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    LOG.debug("Failed to process stdin for " + message + ": " + e, (Throwable)e);
                    throw e;
                }
            }
            finally {
                Closeables.closeQuitely(reader);
            }
        }
    }

    protected static void processInput(InputStream inputStream, String message) throws Exception {
        Processes.readProcessOutput(inputStream, "stdout for ", message);
    }

    protected static void processErrors(InputStream inputStream, String message) throws Exception {
        Processes.readProcessOutput(inputStream, "stderr for ", message);
    }

    protected static void readProcessOutput(InputStream inputStream, final String prefix, final String message) throws Exception {
        Function<String, Void> function = new Function<String, Void>(){

            @Override
            public Void apply(String line) {
                LOG.debug("Error " + prefix + message + ": " + line);
                return null;
            }
        };
        Processes.processOutput(inputStream, function, prefix + message);
    }

    protected static void processOutput(InputStream inputStream, Function<String, Void> function, String errrorMessage) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                function.apply(line);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to process " + errrorMessage + ": " + e, (Throwable)e);
            throw e;
        }
        finally {
            Closeables.closeQuitely(reader);
        }
    }
}

