package io.fabric8.volcano.api.model.flow.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TcpSocketBuilder extends TcpSocketFluent<TcpSocketBuilder> implements VisitableBuilder<TcpSocket,TcpSocketBuilder>{
  public TcpSocketBuilder() {
    this(new TcpSocket());
  }
  
  public TcpSocketBuilder(TcpSocketFluent<?> fluent) {
    this(fluent, new TcpSocket());
  }
  
  public TcpSocketBuilder(TcpSocketFluent<?> fluent,TcpSocket instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TcpSocketBuilder(TcpSocket instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TcpSocketFluent<?> fluent;
  
  public TcpSocket build() {
    TcpSocket buildable = new TcpSocket(fluent.getPort(),fluent.getTaskName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}