
package io.fabric8.volcano.api.model.flow.v1alpha1;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * JobFlowSpec defines the desired state of JobFlow
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "flows",
    "jobRetainPolicy"
})
@ToString
@EqualsAndHashCode
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
@Generated("io.fabric8.kubernetes.schema.generator.model.ModelGenerator")
public class JobFlowSpec implements Editable<JobFlowSpecBuilder>, KubernetesResource
{

    @JsonProperty("flows")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<Flow> flows = new ArrayList<>();
    @JsonProperty("jobRetainPolicy")
    private String jobRetainPolicy;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     */
    public JobFlowSpec() {
    }

    public JobFlowSpec(List<Flow> flows, String jobRetainPolicy) {
        super();
        this.flows = flows;
        this.jobRetainPolicy = jobRetainPolicy;
    }

    /**
     * Foo is an example field of JobFlow. Edit jobflow_types.go to remove/update
     */
    @JsonProperty("flows")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public List<Flow> getFlows() {
        return flows;
    }

    /**
     * Foo is an example field of JobFlow. Edit jobflow_types.go to remove/update
     */
    @JsonProperty("flows")
    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    /**
     * JobFlowSpec defines the desired state of JobFlow
     */
    @JsonProperty("jobRetainPolicy")
    public String getJobRetainPolicy() {
        return jobRetainPolicy;
    }

    /**
     * JobFlowSpec defines the desired state of JobFlow
     */
    @JsonProperty("jobRetainPolicy")
    public void setJobRetainPolicy(String jobRetainPolicy) {
        this.jobRetainPolicy = jobRetainPolicy;
    }

    @JsonIgnore
    public JobFlowSpecBuilder edit() {
        return new JobFlowSpecBuilder(this);
    }

    @JsonIgnore
    public JobFlowSpecBuilder toBuilder() {
        return edit();
    }

    @JsonAnyGetter
    @JsonIgnore
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

}
